/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

final class AppletRunner
implements Runnable {
    private final Applet applet;
    private Thread thread;
    private AbstractNativeRunner runner;

    AppletRunner(Applet applet) {
        if ($assertionsDisabled || applet != null) {
            this.applet = applet;
            return;
        }
        throw new AssertionError((Object)"null a");
    }

    void setRunner(AbstractNativeRunner abstractNativeRunner) {
        if ($assertionsDisabled || abstractNativeRunner != null) {
            this.runner = abstractNativeRunner;
            return;
        }
        throw new AssertionError((Object)"null r");
    }

    private final Value getCallback(String string) {
        return this.runner.getContext().getCodeState().getCallback(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void callback(String string) {
        assert (string != null) : "null cb";
        try {
            Value value = this.runner.getContext().getCodeState().getCallback(string);
            this.runner.callback(value, Value.createInstance(this.applet));
            return;
        }
        catch (Throwable throwable) {
            this.applet.showStatus(throwable.toString());
            return;
        }
    }

    final String getAppletInfo() {
        Value value = this.getCallback("ocamljava java.applet.getAppletInfo");
        return value != null ? value.asString() : null;
    }

    final String[][] getParameterInfo() {
        String[][] stringArray;
        int n;
        BlockValue blockValue;
        Value value = this.getCallback("ocamljava java.applet.getParameterInfo");
        if (value != null) {
            blockValue = value.asBlock();
            n = (int)blockValue.sizeValues();
            stringArray = new String[n][3];
        } else {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            BlockValue blockValue2 = blockValue.get(i).asBlock();
            stringArray[i][0] = blockValue2.get0().asString();
            stringArray[i][1] = blockValue2.get1().asString();
            stringArray[i][2] = blockValue2.get2().asString();
        }
        return stringArray;
    }

    final void init(boolean bl) {
        if (bl) {
            Context context = this.runner.getContext();
            String string = this.applet.getParameter("width") + "x" + this.applet.getParameter("height");
            GraphSlot graphSlot = new GraphSlot(context.getParameters(), "applet", string);
            Canvas canvas = graphSlot.getCanvas();
            this.applet.setLayout(new BorderLayout());
            this.applet.add((Component)canvas, "Center");
            canvas.requestFocus();
            context.getCodeState().registerSlot(GraphSlot.SLOT, graphSlot);
        }
        OCamlJavaThread.registerCodeRunner(Thread.currentThread(), this.runner);
        this.callback("ocamljava java.applet.init");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void start() {
        this.callback("ocamljava java.applet.start");
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
            OCamlJavaThread.registerCodeRunner(this.thread, this.runner);
            return;
        }
        try {
            this.runner.getContext().leaveBlockingSection();
        }
        catch (Throwable throwable) {
            this.applet.showStatus(throwable.toString());
        }
        this.thread.resume();
    }

    final void stop() {
        if (this.thread != null) {
            this.thread.suspend();
            this.runner.getContext().enterBlockingSection();
        }
        this.callback("ocamljava java.applet.stop");
    }

    final void destroy() {
        if (this.thread != null) {
            this.thread.stop();
            this.runner.getContext().enterBlockingSection();
        }
        this.callback("ocamljava java.applet.destroy");
    }

    @Override
    public final void run() {
        this.callback("ocamljava java.applet.run");
    }
}

