/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.MurmurHash3;
import org.ocamljava.runtime.util.PlatformUtils;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Hashtbl", source="byterun/hash.c")
public final class Hash {
    private static final long QUEUE_SIZE = 256L;

    private Hash() {
    }

    public static int caml_hash_mix_uint32(int n, int n2) {
        return MurmurHash3.mix32(n, n2);
    }

    public static int caml_hash_mix_intnat(int n, long l) {
        int n2 = (int)(l >> 32 ^ l >> 63 ^ l);
        return MurmurHash3.mix32(n, n2);
    }

    public static int caml_hash_mix_int64(int n, long l) {
        int n2 = PlatformUtils.isBigEndianPlatform() ? (int)(l & 0xFFFFFFFFL) : (int)(l >>> 32);
        int n3 = PlatformUtils.isBigEndianPlatform() ? (int)(l >>> 32) : (int)(l & 0xFFFFFFFFL);
        int n4 = MurmurHash3.mix32(n, n3);
        n4 = MurmurHash3.mix32(n4, n2);
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int caml_hash_mix_double(int n, double d) {
        int n2;
        long l = Double.doubleToRawLongBits(d);
        int n3 = PlatformUtils.isBigEndianPlatform() ? (int)(l & 0xFFFFFFFFL) : (int)(l >>> 32);
        int n4 = n2 = PlatformUtils.isBigEndianPlatform() ? (int)(l >>> 32) : (int)(l & 0xFFFFFFFFL);
        if ((n3 & 0x7FF00000) == 0x7FF00000 && (n2 | n3 & 0xFFFFF) != 0) {
            n3 = 0x7FF00000;
            n2 = 1;
        } else if (n3 == Integer.MIN_VALUE && n2 == 0) {
            n3 = 0;
        }
        int n5 = MurmurHash3.mix32(n, n2);
        return MurmurHash3.mix32(n5, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int caml_hash_mix_float(int n, float f) {
        int n2 = Float.floatToRawIntBits(f);
        if ((n2 & 0x7F800000) != 2139095040 || (n2 & 0x7FFFFF) == 0) {
            if (n2 == Integer.MIN_VALUE) {
                n2 = 0;
            }
            return MurmurHash3.mix32(n, n2);
        }
        n2 = 2139095041;
        return MurmurHash3.mix32(n, n2);
    }

    public static int caml_hash_mix_string(int n, Value value) {
        int n2;
        int[] nArray = value.getUnsignedBytes();
        int n3 = nArray.length;
        int n4 = n;
        int n5 = 0;
        while (n5 + 4 <= n3) {
            n2 = nArray[n5] | nArray[n5 + 1] << 8 | nArray[n5 + 2] << 16 | nArray[n5 + 3] << 24;
            n4 = MurmurHash3.mix32(n4, n2);
            n5 += 4;
        }
        switch (n3 & 3) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = nArray[n5];
                break;
            }
            case 2: {
                n2 = nArray[n5] | nArray[n5 + 1] << 8;
                break;
            }
            case 3: {
                n2 = nArray[n5] | nArray[n5 + 1] << 8 | nArray[n5 + 2] << 16;
                break;
            }
            default: {
                assert (false) : "should not happen";
                n2 = 0;
            }
        }
        if (n2 != 0) {
            n4 = MurmurHash3.mix32(n4, n2);
        }
        return n4 ^ n3;
    }

    /*
     * Unable to fully structure code
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "int", "'a"}, returnType="int")
    public static Value caml_hash(Value var0, Value var1_1, Value var2_2, Value var3_3) {
        block18: {
            var4_4 = new Value[256];
            var5_5 = var1_1.asLong();
            if (var5_5 >= 0L && var5_5 <= 256L) break block18;
            v0 = 256;
lbl5:
            // 2 sources

            while (true) {
                var7_6 = v0;
                var8_7 = var0.asLong();
                var10_8 = var2_2.asCastedInt();
                var4_4[0] = var3_3;
                var11_9 = 0;
                var12_10 = 1;
                var13_11 = false;
                var14_12 = null;
                block11: while (true) {
                    block19: {
                        if (var11_9 >= var12_10 || var8_7 <= 0L) {
                            var10_8 = MurmurHash3.finalMix32(var10_8);
                            return Value.createLong(var10_8 & 0x3FFFFFFF);
                        }
                        if (var13_11) {
                            var13_11 = false;
                        } else {
                            var14_12 = var4_4[var11_9++];
                        }
                        if (var14_12.isLong()) {
                            var10_8 = Hash.caml_hash_mix_intnat(var10_8, var14_12.getRawValue());
                            --var8_7;
                            continue;
                        }
                        var15_13 = var14_12.getTag();
                        switch (var15_13) {
                            case 251: {
                                continue block11;
                            }
                            case 252: {
                                var10_8 = Hash.caml_hash_mix_string(var10_8, var14_12);
                                --var8_7;
                                continue block11;
                            }
                            case 253: {
                                var10_8 = Hash.caml_hash_mix_double(var10_8, var14_12.asDouble());
                                --var8_7;
                                continue block11;
                            }
                            case 254: {
                                var16_14 = var14_12.sizeDoubles();
                                var18_17 = 0L;
                                break block19;
                            }
                            case 249: {
                                var10_8 = Hash.caml_hash_mix_uint32(var10_8, (int)(var14_12.getWoSize() * 8L));
                                var14_12 = var14_12.getParent();
                                var13_11 = true;
                                continue block11;
                            }
                            case 250: {
                                var14_12 = var14_12.get0();
                                var13_11 = true;
                                continue block11;
                            }
                            case 248: {
                                var10_8 = Hash.caml_hash_mix_intnat(var10_8, var14_12.get1().asLong());
                                --var8_7;
                                continue block11;
                            }
                            case 255: {
                                var16_15 = var3_3.getCustomOperations();
                                if (!var16_15.isHashable()) continue block11;
                                break;
                            }
                            default: {
                                var10_8 = Hash.caml_hash_mix_uint32(var10_8, (int)var14_12.getHeader());
                                var16_16 = var14_12.sizeValues();
                                var18_17 = 0L;
                                while (true) {
                                    if (var18_17 >= var16_16 || var12_10 >= var7_6) continue block11;
                                    var4_4[var12_10++] = var14_12.get(var18_17);
                                    ++var18_17;
                                }
                            }
                        }
                        var10_8 = Hash.caml_hash_mix_uint32(var10_8, (int)var16_15.hash(var14_12));
                        --var8_7;
                        continue;
                    }
                    while (true) {
                        if (var18_17 >= var16_14) continue block11;
                        var10_8 = Hash.caml_hash_mix_double(var10_8, var14_12.getDouble(var18_17));
                        if (--var8_7 >= 0L) ** break;
                        continue block11;
                        ++var18_17;
                    }
                    break;
                }
                break;
            }
        }
        v0 = (int)var5_5;
        ** while (true)
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int", "int", "'a"}, returnType="int")
    public static Value caml_hash_univ_param(Value value, Value value2, Value value3) {
        HashParams hashParams = new HashParams(value2.asLong(), value.asLong());
        Hash.hashVal(value3, hashParams, true);
        return Value.createLong(hashParams.get());
    }

    public static Value hashVariant(String string) {
        long l = 0L;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = IntegerUtils.signedToUnsignedByte(EncodingUtils.convertCharToByte(string.charAt(i)));
            l = 223L * (l >> 1) + (long)n2 << 1;
        }
        return Value.createLong((l &= 0xFFFFFFFEL) >> 1);
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private static void hashVal(Value value, HashParams hashParams, boolean bl) {
        int n;
        int n2;
        byte[] byArray;
        block17: {
            long l;
            long l2;
            block18: {
                CustomOperations customOperations;
                block19: {
                    long l3;
                    if (bl) {
                        hashParams.decrementLimit();
                        if (hashParams.stopHashing()) {
                            return;
                        }
                    }
                    if (value.isLong()) {
                        hashParams.decrementCount();
                        hashParams.combine(value.asLong());
                        return;
                    }
                    int n3 = value.getTag();
                    int n4 = 0;
                    block10: do {
                        switch (n4 == 0 ? n3 : n4) {
                            case 252: {
                                hashParams.decrementCount();
                                byArray = value.getBytes();
                                n2 = byArray.length;
                                n = 0;
                                break block17;
                            }
                            case 253: {
                                hashParams.decrementCount();
                                Hash.hashDouble(value.asDouble(), hashParams);
                                n4 = 251;
                                continue block10;
                            }
                            case 254: {
                                hashParams.decrementCount();
                                l2 = value.sizeDoubles();
                                l = 0L;
                                break block18;
                            }
                            case 249: {
                                Hash.hashVal(value.getParent(), hashParams, true);
                                n4 = 251;
                                continue block10;
                            }
                            case 250: {
                                Hash.hashVal(value.get0(), hashParams, false);
                                return;
                            }
                            case 248: {
                                hashParams.decrementCount();
                                hashParams.combine(value.get1().asLong());
                                n4 = 251;
                                continue block10;
                            }
                            case 255: {
                                customOperations = value.getCustomOperations();
                                if (!customOperations.isHashable()) return;
                                break block19;
                            }
                            default: {
                                hashParams.decrementCount();
                                hashParams.combineSmall(n3);
                                long l4 = value.sizeValues();
                                l3 = l4 - 1L;
                                break;
                            }
                            case 251: {
                                return;
                            }
                        }
                        break;
                    } while (true);
                    while (l3 >= 0L) {
                        Hash.hashVal(value.get(l3), hashParams, true);
                        --l3;
                    }
                    return;
                }
                hashParams.decrementCount();
                hashParams.combine(customOperations.hash(value));
                return;
            }
            while (l < l2) {
                Hash.hashDouble(value.getDouble(l), hashParams);
                ++l;
            }
            return;
        }
        while (n < n2) {
            hashParams.combineSmall(IntegerUtils.signedToUnsignedByte(byArray[n]));
            ++n;
        }
    }

    private static void hashDouble(double d, HashParams hashParams) {
        long l = Double.doubleToRawLongBits(d);
        for (int i = 0; i < 8; ++i) {
            hashParams.combineSmall((int)(l >> i * 8 & 0xFFL));
        }
    }

    private static final class HashParams {
        private static final long ALPHA = 65599L;
        private static final long BETA = 19L;
        private long accu = 0L;
        private long limit;
        private long count;

        private HashParams(long l, long l2) {
            this.limit = l;
            this.count = l2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean stopHashing() {
            if (this.count < 0L) return true;
            if (this.limit >= 0L) return false;
            return true;
        }

        private void decrementCount() {
            --this.count;
        }

        private void decrementLimit() {
            --this.limit;
        }

        private void combineSmall(int n) {
            this.accu = this.accu * 19L + (long)n;
        }

        private void combine(long l) {
            this.accu = this.accu * 65599L + l;
        }

        private int get() {
            return (int)(this.accu & 0x3FFFFFFFL);
        }
    }
}

