/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.util.Iterator;
import org.ocamljava.runtime.kernel.Channel;

final class ChannelMap {
    private static final int SIZE = 256;
    private Channel[] channels = new Channel[256];

    public void put(int n, Channel channel) {
        int n2 = this.channels.length;
        if (n < n2) {
            this.channels[n] = channel;
        } else {
            int n3 = n + 1;
            Channel[] channelArray = new Channel[n3];
            System.arraycopy(this.channels, 0, channelArray, 0, n2);
            channelArray[n] = channel;
            this.channels = channelArray;
        }
    }

    public Channel remove(int n) {
        Channel channel = this.channels[n];
        this.channels[n] = null;
        return channel;
    }

    public Channel get(int n) {
        return this.channels[n];
    }

    public int firstAvailableKey() {
        int n = this.channels.length;
        int n2 = 0;
        while (n2 < n && this.channels[n2] != null) {
            ++n2;
        }
        return n2;
    }

    public Iterator<Channel> valueIterator() {
        return new ChannelIterator(this.channels);
    }

    private static final class ChannelIterator
    implements Iterator<Channel> {
        private final Channel[] array;
        private final int length;
        private int lastReturned;
        private int nextElement;

        private ChannelIterator(Channel[] channelArray) {
            if ($assertionsDisabled || channelArray != null) {
                this.array = channelArray;
                this.length = channelArray.length;
                this.lastReturned = -1;
                this.nextElement = this.computeNextElement(0);
                return;
            }
            throw new AssertionError((Object)"null a");
        }

        @Override
        public boolean hasNext() {
            return this.nextElement < this.length;
        }

        @Override
        public Channel next() {
            Channel channel = this.array[this.nextElement];
            this.lastReturned = this.nextElement;
            this.nextElement = this.computeNextElement(this.nextElement + 1);
            return channel;
        }

        @Override
        public void remove() {
            this.array[this.lastReturned] = null;
        }

        private int computeNextElement(int n) {
            int n2 = n;
            while (n2 < this.length && this.array[n2] == null) {
                ++n2;
            }
            return n2;
        }
    }
}

