/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.ocamljava.runtime.util.IntegerUtils;

public final class IO {
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTE_MASK = 255;

    private IO() {
    }

    public static int read8u(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        {
            return dataInput.readUnsignedByte();
        }
    }

    public static int read8s(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        {
            return dataInput.readByte();
        }
    }

    public static int read16u(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        {
            return dataInput.readUnsignedShort();
        }
    }

    public static int read16s(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        {
            return dataInput.readShort();
        }
    }

    public static long read32u(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        {
            return IntegerUtils.signedToUnsigned(dataInput.readInt());
        }
    }

    public static int read32s(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        {
            return dataInput.readInt();
        }
    }

    public static long read64s(DataInput dataInput) throws IOException {
        assert (dataInput != null) : "null in";
        {
            return dataInput.readLong();
        }
    }

    public static void write8u(DataOutput dataOutput, int n) throws IOException {
        block2: {
            block4: {
                block3: {
                    if (!$assertionsDisabled && dataOutput == null) break block2;
                    if ($assertionsDisabled) break block3;
                    if (n < 0) break block4;
                    if (n > 255) break block4;
                }
                dataOutput.write(n);
                return;
            }
            throw new AssertionError((Object)"val should be in 0..255");
        }
        throw new AssertionError((Object)"null out");
    }

    public static void write8s(DataOutput dataOutput, int n) throws IOException {
        block2: {
            block4: {
                block3: {
                    if (!$assertionsDisabled && dataOutput == null) break block2;
                    if ($assertionsDisabled) break block3;
                    if (n < -128) break block4;
                    if (n > 127) break block4;
                }
                dataOutput.writeByte(n);
                return;
            }
            throw new AssertionError((Object)"val should be in -128..127");
        }
        throw new AssertionError((Object)"null out");
    }

    public static void write16u(DataOutput dataOutput, int n) throws IOException {
        block2: {
            block4: {
                block3: {
                    if (!$assertionsDisabled && dataOutput == null) break block2;
                    if ($assertionsDisabled) break block3;
                    if (n < 0) break block4;
                    if (n > 65535) break block4;
                }
                dataOutput.write(0xFF & n >> 8);
                dataOutput.write(0xFF & n);
                return;
            }
            throw new AssertionError((Object)"val should be in 0..65535");
        }
        throw new AssertionError((Object)"null out");
    }

    public static void write16s(DataOutput dataOutput, int n) throws IOException {
        block2: {
            block4: {
                block3: {
                    if (!$assertionsDisabled && dataOutput == null) break block2;
                    if ($assertionsDisabled) break block3;
                    if (n < Short.MIN_VALUE) break block4;
                    if (n > Short.MAX_VALUE) break block4;
                }
                dataOutput.writeShort(n);
                return;
            }
            throw new AssertionError((Object)"val should be in -32768..32767");
        }
        throw new AssertionError((Object)"null out");
    }

    public static void write32u(DataOutput dataOutput, long l) throws IOException {
        block2: {
            block4: {
                block3: {
                    if (!$assertionsDisabled && dataOutput == null) break block2;
                    if ($assertionsDisabled) break block3;
                    if (l < 0L) break block4;
                    if (l > 0xFFFFFFFFL) break block4;
                }
                dataOutput.writeInt(IntegerUtils.unsignedToSigned(l));
                return;
            }
            throw new AssertionError((Object)"val should be in 0..4294967295");
        }
        throw new AssertionError((Object)"null out");
    }

    public static void write32s(DataOutput dataOutput, int n) throws IOException {
        if ($assertionsDisabled || dataOutput != null) {
            dataOutput.writeInt(n);
            return;
        }
        throw new AssertionError((Object)"null out");
    }

    public static void write64s(DataOutput dataOutput, long l) throws IOException {
        if ($assertionsDisabled || dataOutput != null) {
            dataOutput.writeLong(l);
            return;
        }
        throw new AssertionError((Object)"null out");
    }
}

