/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.ocamljava.runtime.annotations.primitives.Primitives;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.util.CustomClassLoader;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.JarClassLoader;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.PredefinedCustomOperations;
import org.ocamljava.runtime.values.Value;

public final class CodeState {
    private static final String DUMMY_LIB_NAME = "[OCaml-Java-Internal]";
    private static final int NB_ATOMS = 256;
    private static final String NO_FILE = "";
    private final Context context;
    private final Value[] atoms;
    private final boolean isNative;
    private final String file;
    private int[] code;
    private int originalCodeSize;
    private int[] savedCode;
    private int callbackTail;
    private byte[] codeDigest;
    private final Map<String, CustomOperations> customs;
    private final Map<Object, Object> slots;
    private final Map<String, Value> callbacks;
    private Value globalData;
    private Value debugInfo;
    private boolean backtraceActive;
    private Class<?>[] providers;
    private Dispatcher dispatcher;
    private final Map<String, List<Class<?>>> libraries;
    private boolean parserTrace;
    private final long start;
    private final JarClassLoader classLoader;
    private final List<Fragment> fragments;

    CodeState(Context context, CommonParameters commonParameters, boolean bl) {
        if ($assertionsDisabled || context != null) {
            if ($assertionsDisabled || commonParameters != null) {
                this.context = context;
                this.isNative = bl;
                this.file = commonParameters.getFile() != null ? commonParameters.getFile() : NO_FILE;
                this.atoms = new Value[256];
                for (int i = 0; i < 256; ++i) {
                    this.atoms[i] = Value.createAtom(i);
                }
                this.code = new int[0];
                this.savedCode = null;
                this.codeDigest = null;
                this.customs = new HashMap<String, CustomOperations>();
                this.registerCustom(PredefinedCustomOperations.INT_32_OPS);
                this.registerCustom(PredefinedCustomOperations.INT_NAT_OPS);
                this.registerCustom(PredefinedCustomOperations.INT_64_OPS);
                this.registerCustom(PredefinedCustomOperations.CHANNEL_OPS);
                this.registerCustom(PredefinedCustomOperations.JAVA_OPS);
                this.slots = new HashMap<Object, Object>();
                this.start = System.currentTimeMillis();
                this.callbacks = new HashMap<String, Value>();
                this.callbackTail = -1;
                this.globalData = null;
                this.debugInfo = Value.FALSE;
                this.backtraceActive = commonParameters.isBacktraceRequested();
                this.providers = null;
                this.dispatcher = null;
                this.libraries = new LinkedHashMap();
                this.libraries.put(DUMMY_LIB_NAME, null);
                this.parserTrace = false;
                this.classLoader = bl ? new JarClassLoader(this.getClass().getClassLoader()) : null;
                this.fragments = new ArrayList<Fragment>();
                return;
            }
            throw new AssertionError((Object)"null p");
        }
        throw new AssertionError((Object)"null ctxt");
    }

    public boolean isNative() {
        return this.isNative;
    }

    public String getFile() {
        return this.file;
    }

    public Value getAtom(int n) {
        block3: {
            block2: {
                if ($assertionsDisabled) break block2;
                if (n < 0) break block3;
                if (n >= 256) break block3;
            }
            return this.atoms[n];
        }
        throw new AssertionError((Object)"invalid atm");
    }

    public boolean isAtom(Value value) {
        if ($assertionsDisabled || value != null) {
            if (!value.isBlock()) {
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= 256 || this.atoms[n] == value) {
                    return n < 256;
                }
                ++n;
            }
        }
        throw new AssertionError((Object)"null val");
    }

    public int[] getCode() {
        return this.code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int appendCode(int[] nArray) {
        assert (nArray != null) : "null additCode";
        int n = nArray.length;
        int n2 = this.code.length;
        int n3 = n2 + n;
        int[] nArray2 = new int[n3];
        System.arraycopy(this.code, 0, nArray2, 0, n2);
        System.arraycopy(nArray, 0, nArray2, n2, n);
        this.code = nArray2;
        if (n2 == 0) {
            this.originalCodeSize = n3;
        }
        if (!this.context.getDebuggerState().isDebuggerInUse() || n2 != 0) {
            return n2;
        }
        this.savedCode = new int[n3];
        System.arraycopy(this.code, 0, this.savedCode, 0, n3);
        return n2;
    }

    public int getOriginalCodeSize() {
        return this.originalCodeSize;
    }

    public int[] getSavedCode() {
        return this.savedCode;
    }

    public void setupCallbackTail() {
        this.callbackTail = this.appendCode(new int[]{19, 1, 143});
    }

    public int getCallbackTail() {
        return this.callbackTail;
    }

    public void setCodeDigest(byte[] byArray) {
        if ($assertionsDisabled || byArray != null) {
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            this.codeDigest = byArray2;
            this.fragments.add(new Fragment(0, this.code.length, byArray2));
            return;
        }
        throw new AssertionError((Object)"null digest");
    }

    public byte[] getCodeDigest() {
        return Arrays.copyOf(this.codeDigest, this.codeDigest.length);
    }

    public void registerCustom(CustomOperations customOperations) {
        if ($assertionsDisabled || customOperations != null) {
            this.customs.put(customOperations.getIdentifier(), customOperations);
            return;
        }
        throw new AssertionError((Object)"null ops");
    }

    public CustomOperations findCustom(String string) {
        assert (string != null) : "null id";
        {
            return this.customs.get(string);
        }
    }

    public void registerSlot(Object object, Object object2) {
        if ($assertionsDisabled || object != null) {
            this.slots.put(object, object2);
            return;
        }
        throw new AssertionError((Object)"null slot");
    }

    public Object getSlot(Object object) {
        assert (object != null) : "null slot";
        {
            return this.slots.get(object);
        }
    }

    public void removeSlot(Object object) {
        if ($assertionsDisabled || object != null) {
            this.slots.remove(object);
            return;
        }
        throw new AssertionError((Object)"null slot");
    }

    public long getStart() {
        return this.start;
    }

    public void registerCallback(String string, Value value) {
        if ($assertionsDisabled || string != null) {
            if ($assertionsDisabled || value != null) {
                this.callbacks.put(string, value);
                return;
            }
            throw new AssertionError((Object)"null v");
        }
        throw new AssertionError((Object)"null s");
    }

    public Value getCallback(String string) {
        assert (string != null) : "null s";
        {
            return this.callbacks.get(string);
        }
    }

    public Value getGlobalData() {
        return this.globalData;
    }

    public void setGlobalData(Value value) {
        if ($assertionsDisabled || value != null) {
            this.globalData = value;
            return;
        }
        throw new AssertionError((Object)"null gd");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resizeGlobalData(long l) {
        Value value;
        long l2 = this.globalData.sizeValues();
        if (l >= l2) {
            value = Value.createBlock(0, l + 256L & 0xFFFFFFFFFFFFFF00L);
        } else {
            return;
        }
        for (long i = 0L; i < l2; ++i) {
            value.set(i, this.globalData.get(i));
        }
        this.globalData = value;
    }

    public void setDebugInfo(Value value) {
        if ($assertionsDisabled || value != null) {
            this.debugInfo = value;
            return;
        }
        throw new AssertionError((Object)"null di");
    }

    public Value getDebugInfo() {
        return this.debugInfo;
    }

    public boolean isBacktraceActive() {
        return this.backtraceActive;
    }

    public void setBacktraceActive(boolean bl) {
        this.backtraceActive = bl;
    }

    public void setProviders(Class<?>[] classArray) {
        if ($assertionsDisabled || classArray != null) {
            this.providers = Arrays.copyOf(classArray, classArray.length);
            return;
        }
        throw new AssertionError((Object)"null p");
    }

    public void setDispatcher(Dispatcher dispatcher) {
        if ($assertionsDisabled || dispatcher != null) {
            this.dispatcher = dispatcher;
            return;
        }
        throw new AssertionError((Object)"null d");
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value openLib(Value var1_1) throws Fail.Exception {
        block15: {
            block16: {
                if (!CodeState.$assertionsDisabled && var1_1 == null) {
                    throw new AssertionError((Object)"null filename");
                }
                var2_2 = null;
                if (this.context.getFilesState().getFileHook() != null) {
                    var3_3 = this.context.getFilesState().resourceNameFromPath(var1_1);
                    var2_2 = this.context.getFilesState().getFileHook().getURL((String)var3_3);
                }
                if (var2_2 == null && (var3_3 = this.context.getFilesState().getRealFile(var1_1)).exists()) {
                    try {
                        var2_2 = var3_3.toURI().toURL();
                    }
                    catch (MalformedURLException var4_4) {}
                }
                var3_3 = var1_1.asString();
                var4_5 = var3_3;
                var5_6 = 2;
                while (this.libraries.containsKey(var4_5)) {
                    var4_5 = (String)var3_3 + var5_6++;
                }
                if (var2_2 == null) ** GOTO lbl25
                var6_7 = new LinkedList<Class<?>>();
                var7_11 = new URLClassLoader(new URL[]{var2_2}, (ClassLoader)CustomClassLoader.INSTANCE);
                var8_13 = new JarFile(this.file);
                var9_14 = var8_13.entries();
                break block16;
lbl25:
                // 1 sources

                try {
                    var6_8 = Class.forName(var4_5);
                    var7_10 = new LinkedList<Class<?>>();
                    var7_10.add(var6_8);
                    this.libraries.put(var4_5, var7_10);
                    return Value.createAbstract(1L, var4_5);
                }
                catch (Throwable var6_9) {
                    Fail.failWith("cannot open library");
                    return null;
                }
            }
lbl37:
            // 4 sources

            while (var9_14.hasMoreElements()) {
                ** GOTO lbl-1000
            }
            break block15;
            {
                catch (Throwable var7_12) {
                    // empty catch block
                    break block15;
                }
lbl-1000:
                // 1 sources

                {
                    var10_15 = var9_14.nextElement();
                    var11_16 = var10_15.getName();
                    if (!var11_16.endsWith(".class") || var11_16.indexOf(36) != -1) ** GOTO lbl37
                    var12_17 = var11_16.substring(0, var4_5.length() - ".class".length());
                    var13_18 = var12_17.replace('/', '.');
                }
                try {
                    var6_7.add(Class.forName(var13_18, true, var7_11));
                }
                catch (Throwable var14_19) {}
            }
            ** GOTO lbl37
        }
        this.libraries.put(var4_5, var6_7);
        return Value.createAbstract(1L, var4_5);
    }

    public void closeLib(String string) {
        if ($assertionsDisabled || string != null) {
            if (!string.equals(DUMMY_LIB_NAME)) {
                this.libraries.remove(string);
            }
            return;
        }
        throw new AssertionError((Object)"null libname");
    }

    public Value makeLibsArray() {
        int n = this.libraries.size();
        Value value = Value.createBlock(0, n);
        int n2 = 0;
        for (String string : this.libraries.keySet()) {
            value.set(n2++, Value.createAbstract(1L, string));
        }
        return value;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value lookupPrimitive(String string, String string2) {
        assert (string != null) : "null libName";
        assert (string2 != null) : "null symbName";
        boolean bl = true;
        while (true) {
            Iterator iterator;
            block13: {
                Object object;
                block12: {
                    block11: {
                        if (!bl || (bl = false)) break block11;
                        if (!this.libraries.containsKey(string) || (object = this.libraries.get(string)) == null) break block12;
                        iterator = object.iterator();
                    }
                    if (iterator.hasNext()) break block13;
                }
                try {
                    if (this.providers == null) {
                        this.providers = Primitives.getSPIClasses();
                    }
                    if ((object = Primitives.lookupPrimitive(string2, this.providers)) == null) return Value.UNIT;
                    return Value.createAbstract(1L, object);
                }
                catch (OCamlJavaException oCamlJavaException) {
                    // empty catch block
                }
                return Value.UNIT;
            }
            Class clazz = (Class)iterator.next();
            try {
                Method method = Primitives.lookupPrimitive(string2, clazz);
                return Value.createAbstract(1L, method);
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public int addPrimitive(String string, Method method) throws IllegalAccessException {
        if ($assertionsDisabled || string != null) {
            assert (method != null) : "null impl";
            {
                return this.dispatcher.addPrimitive(string, method);
            }
        }
        throw new AssertionError((Object)"null name");
    }

    public boolean isParserTraceEnabled() {
        return this.parserTrace;
    }

    public void setParserTrace(boolean bl) {
        this.parserTrace = bl;
    }

    public JarClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addFragment(int n, byte[] byArray) {
        if ($assertionsDisabled || byArray != null) {
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            this.fragments.add(new Fragment(this.code.length, this.code.length + n, byArray2));
            return;
        }
        throw new AssertionError((Object)"null digest");
    }

    public Fragment getFragment(int n) {
        Fragment fragment;
        Iterator<Fragment> iterator = this.fragments.iterator();
        while (true) {
            if (iterator.hasNext()) {
                fragment = iterator.next();
                if (n < fragment.codeStart) continue;
            } else {
                return null;
            }
            if (n < fragment.codeEnd) break;
        }
        return fragment;
    }

    public Value resolveFragment(byte[] byArray, long l) throws Fatal.Exception {
        Fragment fragment2;
        block1: {
            for (Fragment fragment2 : this.fragments) {
                if (!Arrays.equals(byArray, fragment2.codeDigest)) continue;
                break block1;
            }
            return null;
        }
        return Value.createCodeOffset(IntegerUtils.ensure32s(l + (long)fragment2.codeStart));
    }

    public static final class Fragment {
        public final int codeStart;
        public final int codeEnd;
        public final byte[] codeDigest;

        Fragment(int n, int n2, byte[] byArray) {
            this.codeStart = n;
            this.codeEnd = n2;
            this.codeDigest = byArray;
        }
    }
}

