/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import org.ocamljava.runtime.primitives.stdlib.Hash;
import org.ocamljava.runtime.support.wrappers.ToValue;
import org.ocamljava.runtime.values.Value;

public final class PolymorphicVariant<T>
implements ToValue {
    private final String name;
    private final T value;

    public PolymorphicVariant(String string, T t) {
        if ($assertionsDisabled || string != null) {
            if ($assertionsDisabled || t != null) {
                this.name = string;
                this.value = t;
                return;
            }
            throw new AssertionError((Object)"null v");
        }
        throw new AssertionError((Object)"null n");
    }

    public PolymorphicVariant(String string) {
        if ($assertionsDisabled || string != null) {
            this.name = string;
            this.value = null;
            return;
        }
        throw new AssertionError((Object)"null n");
    }

    @Override
    public Value toValue() {
        if (this.value != null) {
            return Value.createBlock(0, Hash.hashVariant(this.name), this.value.toValue());
        }
        return Hash.hashVariant(this.name);
    }

    public int hashCode() {
        return this.name.hashCode() + (this.value != null ? this.value.hashCode() : 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof PolymorphicVariant)) return false;
        PolymorphicVariant polymorphicVariant = (PolymorphicVariant)object;
        if (!this.name.equals(polymorphicVariant.name)) return false;
        if (this.value == null) {
            if (polymorphicVariant.value == null) return true;
        }
        if (this.value == null) return false;
        if (!this.value.equals(polymorphicVariant.value)) return false;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("`");
        stringBuilder.append(this.name);
        if (this.value != null) {
            stringBuilder.append(" (");
            stringBuilder.append(this.value.toString());
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

