/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.RecursiveTask;
import org.ocamljava.runtime.kernel.NativeApply;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

final class ForkJoinSplitListTask
extends RecursiveTask<Value> {
    static final long serialVersionUID = 0L;
    private final Value fork;
    private final Value join;
    private final Value closure;
    private final Value value;

    ForkJoinSplitListTask(Value f, Value j, Value c, Value x) {
        this.fork = f;
        this.join = j;
        this.closure = c;
        this.value = x;
    }

    @Override
    protected Value compute() {
        try {
            Value forkResult = NativeApply.apply(this.fork, this.value);
            if (forkResult.isLong()) {
                Value res = NativeApply.apply(this.closure, this.value);
                return res;
            }
            LinkedList<ForkJoinSplitListTask> subs = new LinkedList<ForkJoinSplitListTask>();
            Value ptr = forkResult;
            while (ptr.isBlock()) {
                BlockValue b = ptr.asBlock();
                ForkJoinSplitListTask s = new ForkJoinSplitListTask(this.fork, this.join, this.closure, b.get0());
                ptr = b.get1();
                subs.add(s);
                s.fork();
            }
            Iterator it = subs.iterator();
            Value acc = (Value)((ForkJoinSplitListTask)it.next()).join();
            while (it.hasNext()) {
                acc = NativeApply.apply(this.join, acc, (Value)((ForkJoinSplitListTask)it.next()).join());
            }
            return acc;
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
            return null;
        }
    }
}

