/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.scripting;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.ocamljava.runtime.support.scripting.OCamlBindings;
import org.ocamljava.runtime.util.InputStreamFromReader;
import org.ocamljava.runtime.util.PrintStreamToWriter;
import org.ocamljava.runtime.values.Value;

public final class OCamlContext
implements ScriptContext {
    private static final List<Integer> SCOPES = Collections.unmodifiableList(Arrays.asList(100, 200));
    private static OCamlBindings globalScope = null;
    private OCamlBindings engineScope;
    private PrintStream stdOut;
    private PrintStream stdErr;
    private InputStream stdIn;
    private Writer writer;
    private Writer errorWriter;
    private Reader reader;

    public OCamlContext(PrintStream printStream, PrintStream printStream2, InputStream inputStream) {
        if ($assertionsDisabled || printStream != null) {
            if ($assertionsDisabled || printStream2 != null) {
                if ($assertionsDisabled || inputStream != null) {
                    this.engineScope = new OCamlBindings();
                    this.stdOut = printStream;
                    this.stdErr = printStream2;
                    this.stdIn = inputStream;
                    this.writer = new PrintWriter(printStream, true);
                    this.errorWriter = new PrintWriter(printStream2, true);
                    this.reader = new InputStreamReader(inputStream);
                    return;
                }
                throw new AssertionError((Object)"null in");
            }
            throw new AssertionError((Object)"null err");
        }
        throw new AssertionError((Object)"null out");
    }

    public OCamlContext() {
        this(System.out, System.err, System.in);
    }

    public OCamlContext(OCamlContext oCamlContext, OCamlBindings oCamlBindings) {
        if ($assertionsDisabled || oCamlContext != null) {
            if ($assertionsDisabled || oCamlBindings != null) {
                this.engineScope = oCamlBindings;
                this.stdOut = oCamlContext.stdOut;
                this.stdErr = oCamlContext.stdErr;
                this.stdIn = oCamlContext.stdIn;
                this.writer = oCamlContext.writer;
                this.errorWriter = oCamlContext.errorWriter;
                this.reader = oCamlContext.reader;
                return;
            }
            throw new AssertionError((Object)"null b");
        }
        throw new AssertionError((Object)"null that");
    }

    @Override
    public Object getAttribute(String string) throws IllegalArgumentException, NullPointerException {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        if (this.engineScope.containsKey(string)) {
            return this.engineScope.get(string);
        }
        if (globalScope == null || !globalScope.containsKey(string)) {
            return null;
        }
        return globalScope.get(string);
    }

    @Override
    public Object getAttribute(String string, int n) throws IllegalArgumentException, NullPointerException {
        block6: {
            if (string == null) {
                throw new NullPointerException("null name");
            }
            switch (n) {
                case 100: {
                    return this.engineScope.get(string);
                }
                case 200: {
                    if (globalScope != null) {
                        break;
                    }
                    break block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid scope");
                }
            }
            return globalScope.get(string);
        }
        return null;
    }

    @Override
    public int getAttributesScope(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        if (this.engineScope.containsKey(string)) {
            return 100;
        }
        if (globalScope == null || !globalScope.containsKey(string)) {
            return -1;
        }
        return 200;
    }

    /*
     * Enabled aggressive block sorting
     */
    Map<String, Value> getBindings() {
        HashMap<String, Value> hashMap = new HashMap<String, Value>();
        if (globalScope != null) {
            for (String string : globalScope.keySet()) {
                hashMap.put(string, globalScope.getValue(string));
            }
        }
        Iterator<String> iterator = this.engineScope.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            string = iterator.next();
            hashMap.put(string, this.engineScope.getValue(string));
        }
        return hashMap;
    }

    @Override
    public Bindings getBindings(int n) throws IllegalArgumentException {
        switch (n) {
            case 100: {
                return this.engineScope;
            }
            case 200: {
                return globalScope;
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    InputStream getStdIn() {
        return this.stdIn;
    }

    PrintStream getStdOut() {
        return this.stdOut;
    }

    PrintStream getStdErr() {
        return this.stdErr;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public List<Integer> getScopes() {
        return SCOPES;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Object removeAttribute(String string, int n) throws IllegalArgumentException, NullPointerException {
        block6: {
            if (string == null) {
                throw new NullPointerException("null name");
            }
            switch (n) {
                case 100: {
                    return this.engineScope.remove(string);
                }
                case 200: {
                    if (globalScope != null) {
                        break;
                    }
                    break block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid scope");
                }
            }
            return globalScope.remove(string);
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object, int n) throws IllegalArgumentException, NullPointerException {
        block6: {
            if (string == null) {
                throw new NullPointerException("null name");
            }
            switch (n) {
                case 100: {
                    this.engineScope.put(string, object);
                    break block6;
                }
                case 200: {
                    if (globalScope != null) {
                        break;
                    }
                    break block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid scope");
                }
            }
            globalScope.put(string, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setBindings(Bindings bindings, int n) throws IllegalArgumentException, NullPointerException {
        switch (n) {
            case 100: {
                if (bindings == null) {
                    throw new NullPointerException("null bindings for engine scope");
                }
                break;
            }
            case 200: {
                globalScope = OCamlBindings.instance(bindings);
                return;
            }
            default: {
                throw new IllegalArgumentException("invalid scope");
            }
        }
        this.engineScope = OCamlBindings.instance(bindings);
    }

    @Override
    public void setErrorWriter(Writer writer) {
        if (writer != null) {
            this.errorWriter = writer;
            this.stdErr = new PrintStreamToWriter(writer);
        }
    }

    @Override
    public void setReader(Reader reader) {
        if (reader != null) {
            this.reader = reader;
            this.stdIn = new InputStreamFromReader(reader);
        }
    }

    @Override
    public void setWriter(Writer writer) {
        if (writer != null) {
            this.writer = writer;
            this.stdOut = new PrintStreamToWriter(writer);
        }
    }

    static OCamlContext instance(ScriptContext scriptContext) {
        if ($assertionsDisabled || scriptContext != null) {
            if (scriptContext instanceof OCamlContext) {
                return (OCamlContext)scriptContext;
            }
            OCamlContext oCamlContext = new OCamlContext();
            oCamlContext.setErrorWriter(scriptContext.getErrorWriter());
            oCamlContext.setReader(scriptContext.getReader());
            oCamlContext.setWriter(scriptContext.getWriter());
            oCamlContext.setBindings(scriptContext.getBindings(100), 100);
            oCamlContext.setBindings(scriptContext.getBindings(200), 200);
            return oCamlContext;
        }
        throw new AssertionError((Object)"null sc");
    }
}

