/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/write.c")
public final class Write {
    private Write() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "string", "int", "int"}, returnType="int")
    public static Value unix_write(Value value, Value value2, Value value3, Value value4) throws Fail.Exception, FalseExit {
        Channel channel = CurrentContext.FILES_STATE.getChannel(value.asCastedInt());
        if (channel == null) {
            Unix.fail("write", "invalid descriptor");
            return Value.UNIT;
        }
        int n = value3.asCastedInt();
        int n2 = value4.asCastedInt();
        byte[] byArray = value2.getBytesForModification();
        try {
            channel.write(byArray, n, n2);
            channel.flush();
            return value4;
        }
        catch (InterruptedIOException interruptedIOException) {
            FalseExit falseExit = FalseExit.createFromContext(CurrentContext.CONTEXT);
            falseExit.fillInStackTrace();
            throw falseExit;
        }
        catch (IOException iOException) {
            Unix.fail("write", iOException);
            return value4;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Exact synonym of [unix_write]."}, parameterTypes={"Unix.file_descr", "string", "int", "int"}, returnType="int")
    public static Value unix_single_write(Value value, Value value2, Value value3, Value value4) throws Fail.Exception, FalseExit {
        return Write.unix_write(value, value2, value3, value4);
    }
}

