/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class LargeWeakBlockValue
extends BlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private WeakReference<Value>[][] values;

    LargeWeakBlockValue(long l) {
        super(251, l);
        if ($assertionsDisabled || l >= 0L) {
            int n = (int)(l >> 31) + 1;
            int n2 = (int)l & Integer.MAX_VALUE;
            this.length = l;
            this.values = new WeakReference[n][];
            int n3 = 0;
            while (true) {
                if (n3 < n - 1) {
                    this.values[n3] = new WeakReference[Integer.MIN_VALUE];
                } else {
                    this.values[n - 1] = new WeakReference[n2];
                    for (n3 = 0; n3 < n2; ++n3) {
                        this.values[n - 1][n3] = new WeakReference<Object>(null);
                    }
                    return;
                }
                for (int i = 0; i < Integer.MIN_VALUE; ++i) {
                    this.values[n3][i] = new WeakReference<Object>(null);
                }
                ++n3;
            }
        }
        throw new AssertionError((Object)"sz should be >= 0");
    }

    @Override
    public Value getWeak(long l) throws ArrayIndexOutOfBoundsException {
        int n = (int)(l >> 31);
        int n2 = (int)l & Integer.MAX_VALUE;
        return (Value)this.values[n][n2].get();
    }

    @Override
    public void setWeak(long l, Value value) throws ArrayIndexOutOfBoundsException {
        int n = (int)(l >> 31);
        int n2 = (int)l & Integer.MAX_VALUE;
        this.values[n][n2] = new WeakReference<Value>(value);
    }

    @Override
    public long sizeWeakValues() {
        return this.length;
    }

    @Override
    protected void truncateInstance(long l) {
        WeakReference<Value>[][] weakReferenceArray = this.values;
        int n = (int)(l >> 31) + 1;
        int n2 = (int)l & Integer.MAX_VALUE;
        this.length = l;
        this.values = new WeakReference[n][];
        int n3 = 0;
        while (true) {
            if (n3 < n - 1) {
                this.values[n3] = new WeakReference[Integer.MIN_VALUE];
            } else {
                this.values[n - 1] = new WeakReference[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    this.values[n - 1][n3] = weakReferenceArray[n - 1][n3];
                }
                return;
            }
            for (int i = 0; i < Integer.MIN_VALUE; ++i) {
                this.values[n3][i] = weakReferenceArray[n3][i];
            }
            ++n3;
        }
    }

    @Override
    public void copy(BlockValue blockValue) {
        long l = Math.min(this.length, blockValue.sizeWeakValues());
        for (long i = 0L; i < l; ++i) {
            this.setWeak(i, blockValue.getWeak(i));
        }
    }

    @Override
    public LargeWeakBlockValue duplicate() {
        long l = this.length;
        LargeWeakBlockValue largeWeakBlockValue = new LargeWeakBlockValue(l);
        for (long i = 0L; i < l; ++i) {
            largeWeakBlockValue.setWeak(i, this.getWeak(i));
        }
        return largeWeakBlockValue;
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray) {
        int n = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < n; ++i) {
            valueArray[i] = this.getWeak(i);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] valueArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < n2; ++i) {
            valueArray[n + i] = this.getWeak(i);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < n2; ++i) {
            dArray[n + i] = this.getWeak(i).asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] lArray, int n) {
        int n2 = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < n2; ++i) {
            lArray[n + i] = this.getWeak(i).getRawValue();
        }
    }

    @Override
    public Value subArray(long l, long l2) {
        LargeWeakBlockValue largeWeakBlockValue = new LargeWeakBlockValue(l2);
        for (long i = 0L; i < l2; ++i) {
            largeWeakBlockValue.setWeak(i, this.getWeak(i + l));
        }
        return largeWeakBlockValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void blitArray(long l, Value value, long l2, long l3) {
        if (l2 >= l) {
            for (long i = l3 - 1L; i >= 0L; --i) {
                value.setWeak(l2 + i, this.getWeak(l + i));
            }
            return;
        }
        for (long i = 0L; i < l3; ++i) {
            value.setWeak(l2 + i, this.getWeak(l + i));
        }
    }

    public int hashCode() {
        int n = 0;
        WeakReference<Value>[] weakReferenceArray = this.values[0];
        int n2 = Math.min(32, weakReferenceArray.length);
        for (int i = 0; i < n2; ++i) {
            n += weakReferenceArray[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        int n;
        LargeWeakBlockValue largeWeakBlockValue;
        block4: {
            block3: {
                block2: {
                    if (!(object instanceof LargeWeakBlockValue)) break block2;
                    largeWeakBlockValue = (LargeWeakBlockValue)object;
                    n = this.values.length;
                    int n2 = largeWeakBlockValue.values.length;
                    if (n != n) break block3;
                    break block4;
                }
                return false;
            }
            return false;
        }
        int n3 = 0;
        while (n3 < n && Arrays.equals(this.values[n3], largeWeakBlockValue.values[n3])) {
            ++n3;
        }
        return n3 == n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LargeWeakBlockValue(");
        int n = this.values.length;
        int n2 = 0;
        block0: while (true) {
            if (n2 >= n) {
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            int n3 = this.values[n2].length;
            int n4 = 0;
            while (true) {
                Value value;
                block4: {
                    block5: {
                        block3: {
                            if (n4 >= n3) break block3;
                            if (n2 + n4 == 0) break block4;
                            break block5;
                        }
                        ++n2;
                        continue block0;
                    }
                    stringBuilder.append(", ");
                }
                stringBuilder.append((value = (Value)this.values[n2][n4].get()) == null ? "null" : value.toString());
                ++n4;
            }
            break;
        }
    }

    @Override
    public void set(Value value, long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(Value, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setParent(BlockValue blockValue) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object object) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int n) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long l) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long l) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesTagged() {
        assert (false) : "sizeBytesTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        assert (false) : "sizeBytesMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value sizeBytesWrapped() {
        assert (false) : "sizeBytesWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long l, byte by) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long l, int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        {
            return this.get0().asCodeOffset();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCode(long l) {
        if ($assertionsDisabled || this.getTag() == 247 || this.getTag() == 249) {
            this.set0(Value.createCodeOffset(l));
            return;
        }
        throw new AssertionError((Object)("setCode(long) called on an instance of " + this.getClass()));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public long getRawLong(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(long) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong(int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(int) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong0() {
        assert (false) : "getRawLong0() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong1() {
        assert (false) : "getRawLong1() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong2() {
        assert (false) : "getRawLong2() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong3() {
        assert (false) : "getRawLong3() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong4() {
        assert (false) : "getRawLong4() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong5() {
        assert (false) : "getRawLong5() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong6() {
        assert (false) : "getRawLong6() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong7() {
        assert (false) : "getRawLong7() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setRawLong(long l, long l2) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(long, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong(int n, long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(int, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong0(long l) {
        assert (false) : "setRawLong0(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong1(long l) {
        assert (false) : "setRawLong1(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong2(long l) {
        assert (false) : "setRawLong2(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong3(long l) {
        assert (false) : "setRawLong3(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong4(long l) {
        assert (false) : "setRawLong4(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong5(long l) {
        assert (false) : "setRawLong5(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong6(long l) {
        assert (false) : "setRawLong6(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong7(long l) {
        assert (false) : "setRawLong7(long) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeLongs() {
        assert (false) : "sizeLongs() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getDouble(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble(int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble0() {
        assert (false) : "getDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble1() {
        assert (false) : "getDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble2() {
        assert (false) : "getDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble3() {
        assert (false) : "getDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble4() {
        assert (false) : "getDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble5() {
        assert (false) : "getDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble6() {
        assert (false) : "getDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble7() {
        assert (false) : "getDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble0(double d) {
        assert (false) : "setDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble1(double d) {
        assert (false) : "setDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble2(double d) {
        assert (false) : "setDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble3(double d) {
        assert (false) : "setDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble4(double d) {
        assert (false) : "setDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble5(double d) {
        assert (false) : "setDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble6(double d) {
        assert (false) : "setDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble7(double d) {
        assert (false) : "setDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeDoubles() {
        assert (false) : "sizeDoubles() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getGenericDouble(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble(int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble0() {
        assert (false) : "getGenericDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble1() {
        assert (false) : "getGenericDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble2() {
        assert (false) : "getGenericDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble3() {
        assert (false) : "getGenericDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble4() {
        assert (false) : "getGenericDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble5() {
        assert (false) : "getGenericDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble6() {
        assert (false) : "getGenericDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble7() {
        assert (false) : "getGenericDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setGenericDouble(long l, double d) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble(int n, double d) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble0(double d) {
        assert (false) : "setGenericDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble1(double d) {
        assert (false) : "setGenericDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble2(double d) {
        assert (false) : "setGenericDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble3(double d) {
        assert (false) : "setGenericDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble4(double d) {
        assert (false) : "setGenericDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble5(double d) {
        assert (false) : "setGenericDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble6(double d) {
        assert (false) : "setGenericDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble7(double d) {
        assert (false) : "setGenericDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value get(long l) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get(int n) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(int) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get0() {
        assert (false) : "get0() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get1() {
        assert (false) : "get1() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get2() {
        assert (false) : "get2() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get3() {
        assert (false) : "get3() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get4() {
        assert (false) : "get4() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get5() {
        assert (false) : "get5() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get6() {
        assert (false) : "get6() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get7() {
        assert (false) : "get7() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void set(long l, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set(int n, Value value) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(int, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set0(Value value) {
        assert (false) : "set0(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set1(Value value) {
        assert (false) : "set1(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set2(Value value) {
        assert (false) : "set2(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set3(Value value) {
        assert (false) : "set3(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set4(Value value) {
        assert (false) : "set4(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set5(Value value) {
        assert (false) : "set5(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set6(Value value) {
        assert (false) : "set6(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set7(Value value) {
        assert (false) : "set7(Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeValues() {
        assert (false) : "sizeValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLength() {
        assert (false) : "arrayLength() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLengthTagged() {
        assert (false) : "arrayLengthTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        assert (false) : "arrayLengthMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value arrayLengthWrapped() {
        assert (false) : "arrayLengthWrapped() called on an instance of " + this.getClass();
        return null;
    }
}

