/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.toplevel;

import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.ocamljava.runtime.context.FileHook;

final class ThreadedFileHook
extends Thread
implements FileHook {
    private final BlockingQueue<AtomicReference<Request>> parameters = new LinkedBlockingQueue<AtomicReference<Request>>(1);
    private final BlockingQueue<AtomicReference<Response>> results = new LinkedBlockingQueue<AtomicReference<Response>>(1);

    ThreadedFileHook() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                Request request;
                if ((request = this.parameters.take().get()).url) {
                    this.results.put(new AtomicReference<Response>(new Response(this.getClass().getResource(request.file))));
                    continue;
                }
                this.results.put(new AtomicReference<Response>(new Response(this.getClass().getResourceAsStream(request.file))));
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public InputStream getInputStream(String string) {
        try {
            this.parameters.put(new AtomicReference<Request>(new Request(false, string)));
            return this.results.take().get().inputStream;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    @Override
    public URL getURL(String string) {
        try {
            this.parameters.put(new AtomicReference<Request>(new Request(true, string)));
            return this.results.take().get().url;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private static final class Response {
        private final InputStream inputStream;
        private final URL url;

        private Response(InputStream inputStream) {
            this.inputStream = inputStream;
            this.url = null;
        }

        private Response(URL uRL) {
            this.inputStream = null;
            this.url = uRL;
        }
    }

    private static final class Request {
        private final boolean url;
        private final String file;

        private Request(boolean bl, String string) {
            if ($assertionsDisabled || string != null) {
                this.url = bl;
                this.file = string;
                return;
            }
            throw new AssertionError((Object)"null f");
        }
    }
}

