/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/errmsg.c")
public final class Errmsg {
    private static final int E2BIG = 0;
    private static final int EACCES = 1;
    private static final int EAGAIN = 2;
    private static final int EBADF = 3;
    private static final int EBUSY = 4;
    private static final int ECHILD = 5;
    private static final int EDEADLK = 6;
    private static final int EDOM = 7;
    private static final int EEXIST = 8;
    private static final int EFAULT = 9;
    private static final int EFBIG = 10;
    private static final int EINTR = 11;
    private static final int EINVAL = 12;
    private static final int EIO = 13;
    private static final int EISDIR = 14;
    private static final int EMFILE = 15;
    private static final int EMLINK = 16;
    private static final int ENAMETOOLONG = 17;
    private static final int ENFILE = 18;
    private static final int ENODEV = 19;
    private static final int ENOENT = 20;
    private static final int ENOEXEC = 21;
    private static final int ENOLCK = 22;
    private static final int ENOMEM = 23;
    private static final int ENOSPC = 24;
    private static final int ENOSYS = 25;
    private static final int ENOTDIR = 26;
    private static final int ENOTEMPTY = 27;
    private static final int ENOTTY = 28;
    private static final int ENXIO = 29;
    private static final int EPERM = 30;
    private static final int EPIPE = 31;
    private static final int ERANGE = 32;
    private static final int EROFS = 33;
    private static final int ESPIPE = 34;
    private static final int ESRCH = 35;
    private static final int EXDEV = 36;
    private static final int EWOULDBLOCK = 37;
    private static final int EINPROGRESS = 38;
    private static final int EALREADY = 39;
    private static final int ENOTSOCK = 40;
    private static final int EDESTADDRREQ = 41;
    private static final int EMSGSIZE = 42;
    private static final int EPROTOTYPE = 43;
    private static final int ENOPROTOOPT = 44;
    private static final int EPROTONOSUPPORT = 45;
    private static final int ESOCKTNOSUPPORT = 46;
    private static final int EOPNOTSUPP = 47;
    private static final int EPFNOSUPPORT = 48;
    private static final int EAFNOSUPPORT = 49;
    private static final int EADDRINUSE = 50;
    private static final int EADDRNOTAVAIL = 51;
    private static final int ENETDOWN = 52;
    private static final int ENETUNREACH = 53;
    private static final int ENETRESET = 54;
    private static final int ECONNABORTED = 55;
    private static final int ECONNRESET = 56;
    private static final int ENOBUFS = 57;
    private static final int EISCONN = 58;
    private static final int ENOTCONN = 59;
    private static final int ESHUTDOWN = 60;
    private static final int ETOOMANYREFS = 61;
    private static final int ETIMEDOUT = 62;
    private static final int ECONNREFUSED = 63;
    private static final int EHOSTDOWN = 64;
    private static final int EHOSTUNREACH = 65;
    private static final int ELOOP = 66;
    private static final int EOVERFLOW = 67;

    private Errmsg() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.PARTIAL, comment={"Error messages from OCaml source."}, parameterTypes={"Unix.error"}, returnType="string")
    public static Value unix_error_message(Value value) {
        String string;
        if (!value.isLong()) {
            return Value.createString("Unknown error");
        }
        switch (value.asCastedInt()) {
            case 0: {
                string = "Argument list too long";
                break;
            }
            case 1: {
                string = "Permission denied";
                break;
            }
            case 2: {
                string = "Resource temporarily unavailable; try again";
                break;
            }
            case 3: {
                string = "Bad file descriptor";
                break;
            }
            case 4: {
                string = "Resource unavailable";
                break;
            }
            case 5: {
                string = "No child process";
                break;
            }
            case 6: {
                string = "Resource deadlock would occur";
                break;
            }
            case 7: {
                string = "Domain error for math functions, etc.";
                break;
            }
            case 8: {
                string = "File exists";
                break;
            }
            case 9: {
                string = "Bad address";
                break;
            }
            case 10: {
                string = "File too large";
                break;
            }
            case 11: {
                string = "Function interrupted by signal";
                break;
            }
            case 12: {
                string = "Invalid argument";
                break;
            }
            case 13: {
                string = "Hardware I/O error";
                break;
            }
            case 14: {
                string = "Is a directory";
                break;
            }
            case 15: {
                string = "Too many open files by the process";
                break;
            }
            case 16: {
                string = "Too many links";
                break;
            }
            case 17: {
                string = "Filename too long";
                break;
            }
            case 18: {
                string = "Too many open files in the system";
                break;
            }
            case 19: {
                string = "No such device";
                break;
            }
            case 20: {
                string = "No such file or directory";
                break;
            }
            case 21: {
                string = "Not an executable file";
                break;
            }
            case 22: {
                string = "No locks available";
                break;
            }
            case 23: {
                string = "Not enough memory";
                break;
            }
            case 24: {
                string = "No space left on device";
                break;
            }
            case 25: {
                string = "Function not supported";
                break;
            }
            case 26: {
                string = "Not a directory";
                break;
            }
            case 27: {
                string = "Directory not empty";
                break;
            }
            case 28: {
                string = "Inappropriate I/O control operation";
                break;
            }
            case 29: {
                string = "No such device or address";
                break;
            }
            case 30: {
                string = "Operation not permitted";
                break;
            }
            case 31: {
                string = "Broken pipe";
                break;
            }
            case 32: {
                string = "Result too large";
                break;
            }
            case 33: {
                string = "Read-only file system";
                break;
            }
            case 34: {
                string = "Invalid seek e.g. on a pipe";
                break;
            }
            case 35: {
                string = "No such process";
                break;
            }
            case 36: {
                string = "Invalid link";
                break;
            }
            case 37: {
                string = "Operation would block";
                break;
            }
            case 38: {
                string = "Operation now in progress";
                break;
            }
            case 39: {
                string = "Operation already in progress";
                break;
            }
            case 40: {
                string = "Socket operation on non-socket";
                break;
            }
            case 41: {
                string = "Destination address required";
                break;
            }
            case 42: {
                string = "Message too long";
                break;
            }
            case 43: {
                string = "Protocol wrong type for socket";
                break;
            }
            case 44: {
                string = "Protocol not available";
                break;
            }
            case 45: {
                string = "Protocol not supported";
                break;
            }
            case 46: {
                string = "Socket type not supported";
                break;
            }
            case 47: {
                string = "Operation not supported on socket";
                break;
            }
            case 48: {
                string = "Protocol family not supported";
                break;
            }
            case 49: {
                string = "Address family not supported by protocol family";
                break;
            }
            case 50: {
                string = "Address already in use";
                break;
            }
            case 51: {
                string = "Can't assign requested address";
                break;
            }
            case 52: {
                string = "Network is down";
                break;
            }
            case 53: {
                string = "Network is unreachable";
                break;
            }
            case 54: {
                string = "Network dropped connection on reset";
                break;
            }
            case 55: {
                string = "Software caused connection abort";
                break;
            }
            case 56: {
                string = "Connection reset by peer";
                break;
            }
            case 57: {
                string = "No buffer space available";
                break;
            }
            case 58: {
                string = "Socket is already connected";
                break;
            }
            case 59: {
                string = "Socket is not connected";
                break;
            }
            case 60: {
                string = "Can't send after socket shutdown";
                break;
            }
            case 61: {
                string = "Too many references: can't splice";
                break;
            }
            case 62: {
                string = "Connection timed out";
                break;
            }
            case 63: {
                string = "Connection refused";
                break;
            }
            case 64: {
                string = "Host is down";
                break;
            }
            case 65: {
                string = "No route to host";
                break;
            }
            case 66: {
                string = "Too many levels of symbolic links";
                break;
            }
            case 67: {
                string = "File size or position not representable";
                break;
            }
            default: {
                assert (false) : "invalid error code";
                string = "Unknown error";
            }
        }
        return Value.createString(string);
    }
}

