/*
 * Decompiled with CFR 0.152.
 */
package ocaml.stdlib;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.ocamljava.runtime.annotations.markers.CompiledModule;
import org.ocamljava.runtime.kernel.AbstractNativeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaModule;
import org.ocamljava.runtime.kernel.ThreadLocalFactory;
import org.ocamljava.runtime.primitives.stdlib.Ints;
import org.ocamljava.runtime.values.Value;

@CompiledModule
public final class Int32
implements OCamlJavaModule {
    public static final ThreadLocal GLOBALS;
    private static final ThreadLocal CONSTANTS;
    public static final MethodHandle succ_1029;
    public static final MethodHandle pred_1031;
    public static final MethodHandle abs_1033;
    public static final MethodHandle lognot_1037;
    public static final MethodHandle to_string_1040;
    public static final MethodHandle compare_1044;

    static {
        CONSTANTS = ThreadLocalFactory.constantsStorage(Int32.class);
        GLOBALS = ThreadLocalFactory.globalStorage("Int32");
        succ_1029 = cfr_ldc_0();
        pred_1031 = cfr_ldc_1();
        abs_1033 = cfr_ldc_2();
        lognot_1037 = cfr_ldc_3();
        to_string_1040 = cfr_ldc_4();
        compare_1044 = cfr_ldc_5();
    }

    public static Value succ_1029(Value n) throws Fail.Exception, Fatal.Exception {
        return Value.createInt32(n.asInt32() + 1);
    }

    public static Value pred_1031(Value n) throws Fail.Exception, Fatal.Exception {
        return Value.createInt32(n.asInt32() - 1);
    }

    public static Value abs_1033(Value n) throws Fail.Exception, Fatal.Exception {
        return (int)(n.asInt32() < 0 ? 0L : 1L) != 0 ? n : Value.createInt32(-n.asInt32());
    }

    public static Value lognot_1037(Value n) throws Fail.Exception, Fatal.Exception {
        return Value.createInt32(~n.asInt32());
    }

    public static Value to_string_1040(Value n) throws Fail.Exception, Fatal.Exception {
        Value value = (Value)CONSTANTS.get();
        return Ints.caml_int32_format(value.get(0), n);
    }

    public static Value compare_1044(Value x, Value y) throws Fail.Exception, Fatal.Exception {
        return Ints.caml_int32_compare(x, y);
    }

    public static Value entry() throws Fail.Exception, Fatal.Exception {
        Value value = AbstractNativeRunner.createGlobal("Int32", 11);
        value.set0(Value.createInt32(0));
        value.set1(Value.createInt32(1));
        value.set2(Value.createInt32(-1));
        Value value2 = Value.createClosure(succ_1029);
        value.set3(value2);
        value2 = Value.createClosure(pred_1031);
        value.set4(value2);
        value2 = Value.createClosure(abs_1033);
        value.set5(value2);
        value.set7(Value.createInt32(Integer.MIN_VALUE));
        value.set6(Value.createInt32(Integer.MAX_VALUE));
        value2 = Value.createClosure(lognot_1037);
        value.set(8, value2);
        value2 = Value.createClosure(to_string_1040);
        value.set(9, value2);
        value2 = Value.createClosure(compare_1044, 2);
        value.set(10, value2);
        return Value.ZERO;
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_0() {
        try {
            return MethodHandles.lookup().findStatic(Int32.class, "succ_1029", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_1() {
        try {
            return MethodHandles.lookup().findStatic(Int32.class, "pred_1031", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_2() {
        try {
            return MethodHandles.lookup().findStatic(Int32.class, "abs_1033", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_3() {
        try {
            return MethodHandles.lookup().findStatic(Int32.class, "lognot_1037", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_4() {
        try {
            return MethodHandles.lookup().findStatic(Int32.class, "to_string_1040", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }

    /*
     * Works around MethodHandle LDC.
     */
    static MethodHandle cfr_ldc_5() {
        try {
            return MethodHandles.lookup().findStatic(Int32.class, "compare_1044", MethodType.fromMethodDescriptorString("(Lorg/ocamljava/runtime/values/Value;Lorg/ocamljava/runtime/values/Value;)Lorg/ocamljava/runtime/values/Value;", null));
        }
        catch (NoSuchMethodException | IllegalAccessException except) {
            throw new IllegalArgumentException(except);
        }
    }
}

