/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.math.BigInteger;
import java.util.Formatter;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.stdlib.Compare;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="", source="byterun/ints.c")
public final class Ints {
    private Ints() {
    }

    private static int parseDigit(char ch, int base) throws Fail.Exception {
        int res = ch >= '0' && ch <= '9' ? ch - 48 : (ch >= 'A' && ch <= 'F' ? ch - 65 + 10 : (ch >= 'a' && ch <= 'f' ? ch - 97 + 10 : -1));
        if (res < 0 || res >= base) {
            Fail.failWith("int_of_string");
            return 0;
        }
        return res;
    }

    private static long parseLong(String s, int bits) throws Fail.Exception {
        BigInteger max;
        BigInteger min;
        assert (s != null) : "null s";
        assert (bits > 0) : "bits should be > 0";
        int idx = 0;
        int sign = 1;
        int len = s.length();
        BigInteger base = BigInteger.TEN;
        if (s.charAt(idx) == '-') {
            ++idx;
            sign = -1;
        }
        if (idx + 1 < len && s.charAt(idx) == '0') {
            switch (s.charAt(idx + 1)) {
                case 'X': 
                case 'x': {
                    base = BigInteger.valueOf(16L);
                    idx += 2;
                    break;
                }
                case 'O': 
                case 'o': {
                    base = BigInteger.valueOf(8L);
                    idx += 2;
                    break;
                }
                case 'B': 
                case 'b': {
                    base = BigInteger.valueOf(2L);
                    idx += 2;
                    break;
                }
            }
        }
        int b = base.intValue();
        if (idx >= len) {
            Fail.failWith("int_of_string");
            return 0L;
        }
        BigInteger res = BigInteger.valueOf(Ints.parseDigit(s.charAt(idx++), b));
        while (idx < len) {
            char ch = s.charAt(idx);
            if (ch != '_') {
                res = res.multiply(base).add(BigInteger.valueOf(Ints.parseDigit(ch, b)));
            }
            ++idx;
        }
        if (b == 10) {
            min = BigInteger.valueOf(2L).pow(bits - 1).negate();
            max = BigInteger.valueOf(2L).pow(bits - 1).subtract(BigInteger.ONE);
        } else {
            min = BigInteger.valueOf(2L).pow(bits).subtract(BigInteger.ONE).negate();
            max = BigInteger.valueOf(2L).pow(bits).subtract(BigInteger.ONE);
        }
        if (res.compareTo(min) >= 0 && res.compareTo(max) <= 0) {
            return sign < 0 ? -res.longValue() : res.longValue();
        }
        Fail.failWith("int_of_string");
        return 0L;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="[runtime]", parameterTypes={"int", "int"}, returnType="int")
    public static Value caml_int_compare(Value v1, Value v2) {
        long r2;
        long r1 = v1.asLong();
        if (r1 < (r2 = v2.asLong())) {
            return Compare.LESS_VALUE;
        }
        if (r1 > r2) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="[runtime]", parameterTypes={"string"}, returnType="int")
    public static Value caml_int_of_string(Value s) throws Fail.Exception {
        return Value.createLong(Ints.parseLong(s.asString(), 63));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="[runtime]", parameterTypes={"string", "int"}, returnType="string")
    public static Value caml_format_int(Value fmt, Value arg) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        String format = fmt.asString();
        long argument = arg.asLong();
        char ch = format.charAt(format.length() - 1);
        if (ch == 'i') {
            format = format.substring(0, format.length() - 1) + "d";
        } else if (ch == 'u') {
            format = format.substring(0, format.length() - 1) + "d";
            if (argument < 0L) {
                String res = BigInteger.ONE.shiftLeft(63).add(BigInteger.valueOf(argument)).toString();
                return Value.createString(res);
            }
        }
        f.format(format, argument);
        return Value.createString(sb.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32"}, returnType="int32")
    public static Value caml_int32_neg(Value v) {
        return Value.createInt32(-v.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_add(Value v1, Value v2) {
        return Value.createInt32(v1.asInt32() + v2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_sub(Value v1, Value v2) {
        return Value.createInt32(v1.asInt32() - v2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_mul(Value v1, Value v2) {
        return Value.createInt32(v1.asInt32() * v2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_div(Value v1, Value v2) throws Fail.Exception {
        try {
            return Value.createInt32(v1.asInt32() / v2.asInt32());
        }
        catch (ArithmeticException ae) {
            Fail.raiseZeroDivide();
            return Value.ZERO;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_mod(Value v1, Value v2) throws Fail.Exception {
        try {
            return Value.createInt32(v1.asInt32() % v2.asInt32());
        }
        catch (ArithmeticException ae) {
            Fail.raiseZeroDivide();
            return Value.ZERO;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_and(Value v1, Value v2) {
        return Value.createInt32(v1.asInt32() & v2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_or(Value v1, Value v2) {
        return Value.createInt32(v1.asInt32() | v2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int32")
    public static Value caml_int32_xor(Value v1, Value v2) {
        return Value.createInt32(v1.asInt32() ^ v2.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int"}, returnType="int32")
    public static Value caml_int32_shift_left(Value v1, Value v2) {
        return Value.createInt32(v1.asInt32() << (int)v2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int"}, returnType="int32")
    public static Value caml_int32_shift_right(Value v1, Value v2) {
        return Value.createInt32(v1.asInt32() >> (int)v2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int"}, returnType="int32")
    public static Value caml_int32_shift_right_unsigned(Value v1, Value v2) {
        return Value.createInt32(v1.asInt32() >>> (int)v2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int"}, returnType="int32")
    public static Value caml_int32_of_int(Value v) {
        return Value.createInt32((int)v.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32"}, returnType="int")
    public static Value caml_int32_to_int(Value v) {
        return Value.createLong(v.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"float"}, returnType="int32")
    public static Value caml_int32_of_float(Value v) {
        return Value.createInt32((int)v.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32"}, returnType="float")
    public static Value caml_int32_to_float(Value v) {
        return Value.createDouble(v.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32", "int32"}, returnType="int")
    public static Value caml_int32_compare(Value v1, Value v2) {
        int r2;
        int r1 = v1.asInt32();
        if (r1 < (r2 = v2.asInt32())) {
            return Compare.LESS_VALUE;
        }
        if (r1 > r2) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"string", "int32"}, returnType="string")
    public static Value caml_int32_format(Value fmt, Value arg) {
        char ch;
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        String format = fmt.asString();
        long argument = arg.asInt32();
        if (format.length() >= 2 && format.charAt(format.length() - 2) == 'l') {
            format = format.substring(0, format.length() - 2) + format.substring(format.length() - 1);
        }
        if ((ch = format.charAt(format.length() - 1)) == 'i') {
            format = format.substring(0, format.length() - 1) + "d";
        } else if (ch == 'u') {
            format = format.substring(0, format.length() - 1) + "d";
            argument = IntegerUtils.signedToUnsigned((int)argument);
        }
        f.format(format, argument);
        return Value.createString(sb.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"string"}, returnType="int32")
    public static Value caml_int32_of_string(Value s) throws Fail.Exception {
        return Value.createInt32((int)Ints.parseLong(s.asString(), 32));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"float"}, returnType="int32")
    public static Value caml_int32_bits_of_float(Value v) {
        return Value.createInt32(Float.floatToRawIntBits((float)v.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int32", parameterTypes={"int32"}, returnType="float")
    public static Value caml_int32_float_of_bits(Value v) {
        return Value.createDouble(Float.intBitsToFloat(v.asInt32()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="int64")
    public static Value caml_int64_neg(Value v) {
        return Value.createInt64(-v.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_add(Value v1, Value v2) {
        return Value.createInt64(v1.asInt64() + v2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_sub(Value v1, Value v2) {
        return Value.createInt64(v1.asInt64() - v2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_mul(Value v1, Value v2) {
        return Value.createInt64(v1.asInt64() * v2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_div(Value v1, Value v2) throws Fail.Exception {
        try {
            return Value.createInt64(v1.asInt64() / v2.asInt64());
        }
        catch (ArithmeticException ae) {
            Fail.raiseZeroDivide();
            return Value.ZERO;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_mod(Value v1, Value v2) throws Fail.Exception {
        try {
            return Value.createInt64(v1.asInt64() % v2.asInt64());
        }
        catch (ArithmeticException ae) {
            Fail.raiseZeroDivide();
            return Value.ZERO;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_and(Value v1, Value v2) {
        return Value.createInt64(v1.asInt64() & v2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_or(Value v1, Value v2) {
        return Value.createInt64(v1.asInt64() | v2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int64")
    public static Value caml_int64_xor(Value v1, Value v2) {
        return Value.createInt64(v1.asInt64() ^ v2.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int"}, returnType="int64")
    public static Value caml_int64_shift_left(Value v1, Value v2) {
        return Value.createInt64(v1.asInt64() << (int)v2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int"}, returnType="int64")
    public static Value caml_int64_shift_right(Value v1, Value v2) {
        return Value.createInt64(v1.asInt64() >> (int)v2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int"}, returnType="int64")
    public static Value caml_int64_shift_right_unsigned(Value v1, Value v2) {
        return Value.createInt64(v1.asInt64() >>> (int)v2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int"}, returnType="int64")
    public static Value caml_int64_of_int(Value v) {
        return Value.createInt64(v.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="int")
    public static Value caml_int64_to_int(Value v) {
        return Value.createLong(v.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"float"}, returnType="int64")
    public static Value caml_int64_of_float(Value v) {
        return Value.createInt64((long)v.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="float")
    public static Value caml_int64_to_float(Value v) {
        return Value.createDouble(v.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int32"}, returnType="int64")
    public static Value caml_int64_of_int32(Value v) {
        return Value.createInt64(v.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="int32")
    public static Value caml_int64_to_int32(Value v) {
        return Value.createInt32((int)v.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"nativeint"}, returnType="int64")
    public static Value caml_int64_of_nativeint(Value v) {
        return Value.createInt64(v.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="nativeint")
    public static Value caml_int64_to_nativeint(Value v) {
        return Value.createNativeInt(v.asInt64());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64", "int64"}, returnType="int")
    public static Value caml_int64_compare(Value v1, Value v2) {
        long r2;
        long r1 = v1.asInt64();
        if (r1 < (r2 = v2.asInt64())) {
            return Compare.LESS_VALUE;
        }
        if (r1 > r2) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"string", "int64"}, returnType="string")
    public static Value caml_int64_format(Value fmt, Value arg) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        String format = fmt.asString();
        long argument = arg.asInt64();
        if (format.length() >= 2 && format.charAt(format.length() - 2) == 'L') {
            format = format.substring(0, format.length() - 2) + format.substring(format.length() - 1);
        }
        if (format.charAt(format.length() - 1) == 'i') {
            format = format.substring(0, format.length() - 1) + "d";
        } else if (format.charAt(format.length() - 1) == 'u') {
            format = format.substring(0, format.length() - 1) + "d";
            if (argument < 0L) {
                String res = BigInteger.ONE.shiftLeft(64).add(BigInteger.valueOf(argument)).toString();
                return Value.createString(res);
            }
        }
        f.format(format, argument);
        return Value.createString(sb.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"string"}, returnType="int64")
    public static Value caml_int64_of_string(Value s) throws Fail.Exception {
        return Value.createInt64(Ints.parseLong(s.asString(), 64));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"float"}, returnType="int64")
    public static Value caml_int64_bits_of_float(Value v) {
        return Value.createInt64(Double.doubleToRawLongBits(v.asDouble()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Int64", parameterTypes={"int64"}, returnType="float")
    public static Value caml_int64_float_of_bits(Value val) {
        return Value.createDouble(Double.longBitsToDouble(val.asInt64()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_neg(Value v) {
        return Value.createNativeInt(-v.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_add(Value v1, Value v2) {
        return Value.createNativeInt(v1.asNativeInt() + v2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_sub(Value v1, Value v2) {
        return Value.createNativeInt(v1.asNativeInt() - v2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_mul(Value v1, Value v2) {
        return Value.createNativeInt(v1.asNativeInt() * v2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_div(Value v1, Value v2) throws Fail.Exception {
        try {
            return Value.createNativeInt(v1.asNativeInt() / v2.asNativeInt());
        }
        catch (ArithmeticException ae) {
            Fail.raiseZeroDivide();
            return Value.ZERO;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_mod(Value v1, Value v2) throws Fail.Exception {
        try {
            return Value.createNativeInt(v1.asNativeInt() % v2.asNativeInt());
        }
        catch (ArithmeticException ae) {
            Fail.raiseZeroDivide();
            return Value.ZERO;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_and(Value v1, Value v2) {
        return Value.createNativeInt(v1.asNativeInt() & v2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_or(Value v1, Value v2) {
        return Value.createNativeInt(v1.asNativeInt() | v2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="nativeint")
    public static Value caml_nativeint_xor(Value v1, Value v2) {
        return Value.createNativeInt(v1.asNativeInt() ^ v2.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "int"}, returnType="nativeint")
    public static Value caml_nativeint_shift_left(Value v1, Value v2) {
        return Value.createNativeInt(v1.asNativeInt() << (int)v2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "int"}, returnType="nativeint")
    public static Value caml_nativeint_shift_right(Value v1, Value v2) {
        return Value.createNativeInt(v1.asNativeInt() >> (int)v2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "int"}, returnType="nativeint")
    public static Value caml_nativeint_shift_right_unsigned(Value v1, Value v2) {
        return Value.createNativeInt(v1.asNativeInt() >>> (int)v2.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"int"}, returnType="nativeint")
    public static Value caml_nativeint_of_int(Value v) {
        return Value.createNativeInt(v.asLong());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint"}, returnType="int")
    public static Value caml_nativeint_to_int(Value v) {
        return Value.createLong(v.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"float"}, returnType="nativeint")
    public static Value caml_nativeint_of_float(Value v) {
        return Value.createNativeInt((long)v.asDouble());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint"}, returnType="float")
    public static Value caml_nativeint_to_float(Value v) {
        return Value.createDouble(v.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"int32"}, returnType="nativeint")
    public static Value caml_nativeint_of_int32(Value v) {
        return Value.createNativeInt(v.asInt32());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint"}, returnType="int32")
    public static Value caml_nativeint_to_int32(Value v) {
        return Value.createInt32((int)v.asNativeInt());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"nativeint", "nativeint"}, returnType="int")
    public static Value caml_nativeint_compare(Value v1, Value v2) {
        long r2;
        long r1 = v1.asNativeInt();
        if (r1 < (r2 = v2.asNativeInt())) {
            return Compare.LESS_VALUE;
        }
        if (r1 > r2) {
            return Compare.GREATER_VALUE;
        }
        return Compare.EQUAL_VALUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"string", "nativeint"}, returnType="string")
    public static Value caml_nativeint_format(Value fmt, Value arg) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        String format = fmt.asString();
        long argument = arg.asNativeInt();
        if (format.length() >= 2 && format.charAt(format.length() - 2) == 'n') {
            format = format.substring(0, format.length() - 2) + format.substring(format.length() - 1);
        }
        if (format.charAt(format.length() - 1) == 'i') {
            format = format.substring(0, format.length() - 1) + "d";
        } else if (format.charAt(format.length() - 1) == 'u') {
            format = format.substring(0, format.length() - 1) + "d";
            if (argument < 0L) {
                String res = BigInteger.ONE.shiftLeft(64).add(BigInteger.valueOf(argument)).toString();
                return Value.createString(res);
            }
        }
        f.format(format, argument);
        return Value.createString(sb.toString());
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, module="Nativeint", parameterTypes={"string"}, returnType="nativeint")
    public static Value caml_nativeint_of_string(Value s) throws Fail.Exception {
        return Value.createNativeInt(Ints.parseLong(s.asString(), 64));
    }
}

