/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.values.AbstractLongBlockValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.LongBlockValue0;
import org.ocamljava.runtime.values.LongBlockValue1;
import org.ocamljava.runtime.values.LongBlockValue2;
import org.ocamljava.runtime.values.LongBlockValue3;
import org.ocamljava.runtime.values.LongBlockValue4;
import org.ocamljava.runtime.values.LongBlockValue5;
import org.ocamljava.runtime.values.LongBlockValue6;
import org.ocamljava.runtime.values.LongBlockValue7;
import org.ocamljava.runtime.values.LongBlockValue8;
import org.ocamljava.runtime.values.Value;

public final class LongBlockValue
extends AbstractLongBlockValue {
    private int sizeTagged;
    private int sizeMinusOneTagged;
    private Value sizeWrapped;
    private long[] values;

    LongBlockValue(int tag, int sz) {
        super(tag, sz);
        this.values = new long[sz];
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
    }

    LongBlockValue(int tag, long[] vals) {
        super(tag, vals.length);
        int sz = vals.length;
        this.values = vals;
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
    }

    @Override
    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx];
    }

    @Override
    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx];
    }

    @Override
    public long getRawLong0() {
        return this.values[0];
    }

    @Override
    public long getRawLong1() {
        return this.values[1];
    }

    @Override
    public long getRawLong2() {
        return this.values[2];
    }

    @Override
    public long getRawLong3() {
        return this.values[3];
    }

    @Override
    public long getRawLong4() {
        return this.values[4];
    }

    @Override
    public long getRawLong5() {
        return this.values[5];
    }

    @Override
    public long getRawLong6() {
        return this.values[6];
    }

    @Override
    public long getRawLong7() {
        return this.values[7];
    }

    @Override
    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        this.values[(int)idx] = x;
    }

    @Override
    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        this.values[idx] = x;
    }

    @Override
    public void setRawLong0(long x) {
        this.values[0] = x;
    }

    @Override
    public void setRawLong1(long x) {
        this.values[1] = x;
    }

    @Override
    public void setRawLong2(long x) {
        this.values[2] = x;
    }

    @Override
    public void setRawLong3(long x) {
        this.values[3] = x;
    }

    @Override
    public void setRawLong4(long x) {
        this.values[4] = x;
    }

    @Override
    public void setRawLong5(long x) {
        this.values[5] = x;
    }

    @Override
    public void setRawLong6(long x) {
        this.values[6] = x;
    }

    @Override
    public void setRawLong7(long x) {
        this.values[7] = x;
    }

    @Override
    public long sizeLongs() {
        return this.values.length;
    }

    @Override
    public long arrayLength() {
        return this.values.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long sz) {
        int s = (int)sz;
        this.values = Arrays.copyOf(this.values, s);
        this.sizeTagged = s << 1 | 1;
        this.sizeMinusOneTagged = s - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(s);
    }

    @Override
    public void copy(BlockValue src) {
        int len = (int)Math.min((long)this.values.length, src.sizeLongs());
        for (int i = 0; i < len; ++i) {
            this.values[i] = src.getRawLong(i);
        }
    }

    @Override
    public LongBlockValue duplicate() {
        int len = this.values.length;
        LongBlockValue res = new LongBlockValue(this.getTag(), len);
        System.arraycopy(this.values, 0, res.values, 0, len);
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[i] = Value.createFromRawLong(this.values[i]);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = Value.createFromRawLong(this.values[i]);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.values[i];
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        System.arraycopy(this.values, 0, dest, destOfs, this.values.length);
    }

    @Override
    public Value subArray(long ofs, long len) {
        int l = (int)len;
        int o = (int)ofs;
        int tag = this.getTag();
        switch (l) {
            case 0: {
                return new LongBlockValue0(tag);
            }
            case 1: {
                return new LongBlockValue1(tag, this.values[o + 0]);
            }
            case 2: {
                return new LongBlockValue2(tag, this.values[o + 0], this.values[o + 1]);
            }
            case 3: {
                return new LongBlockValue3(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2]);
            }
            case 4: {
                return new LongBlockValue4(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3]);
            }
            case 5: {
                return new LongBlockValue5(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4]);
            }
            case 6: {
                return new LongBlockValue6(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5]);
            }
            case 7: {
                return new LongBlockValue7(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6]);
            }
            case 8: {
                return new LongBlockValue8(tag, this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6], this.values[o + 7]);
            }
        }
        long[] v = new long[l];
        System.arraycopy(this.values, o, v, 0, l);
        return new LongBlockValue(tag, v);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (dest instanceof LongBlockValue) {
            LongBlockValue that = (LongBlockValue)dest;
            System.arraycopy(this.values, (int)srcOfs, that.values, (int)destOfs, (int)len);
        } else if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.setRawLong(destOfs + i, this.getRawLong(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.setRawLong(destOfs + i, this.getRawLong(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        int len = Math.min(32, this.values.length);
        for (int i = 0; i < len; ++i) {
            res += (int)this.values[i];
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongBlockValue) {
            LongBlockValue that = (LongBlockValue)obj;
            return Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LongBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.values[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void setParent(BlockValue b) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object o) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int v) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long v) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long v) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long code) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(code));
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long i) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long i, Value v) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytes() {
        assert (false) : "sizeBytes() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesTagged() {
        assert (false) : "sizeBytesTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        assert (false) : "sizeBytesMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value sizeBytesWrapped() {
        assert (false) : "sizeBytesWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public String asString() {
        assert (false) : "asString() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "getBytes() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public byte[] getBytesForModification() {
        assert (false) : "getBytesForModification() called on an instance of " + this.getClass();
        return new byte[0];
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "getUnsignedBytes() called on an instance of " + this.getClass();
        return new int[0];
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setByte(long, byte) called on an instance of " + this.getClass();
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getUnsignedByte(long) called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setUnsignedByte(long, int) called on an instance of " + this.getClass();
    }

    @Override
    public void set(Value x, long idx) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        this.values[(int)idx] = x.asLong();
    }

    @Override
    public long sizeDoubles() {
        return this.values.length;
    }

    @Override
    public void setGenericDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[idx] = (long)x;
    }

    @Override
    public void setGenericDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[(int)idx] = (long)x;
    }

    @Override
    public double getGenericDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx];
    }

    @Override
    public double getGenericDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx];
    }

    @Override
    public double getDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx];
    }

    @Override
    public double getDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx];
    }

    @Override
    public void setDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[idx] = (long)x;
    }

    @Override
    public void setDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[(int)idx] = (long)x;
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        return Value.createFromRawLong(this.values[idx]);
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        return Value.createFromRawLong(this.values[(int)idx]);
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        this.values[idx] = x.getRawValue();
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        this.values[(int)idx] = x.getRawValue();
    }

    @Override
    public void setGenericDouble0(double x) {
        this.values[0] = (long)x;
    }

    @Override
    public double getGenericDouble0() {
        return this.values[0];
    }

    @Override
    public void setDouble0(double x) {
        this.values[0] = (long)x;
    }

    @Override
    public double getDouble0() {
        return this.values[0];
    }

    @Override
    public void set0(Value x) {
        this.values[0] = x.getRawValue();
    }

    @Override
    public Value get0() {
        return Value.createFromRawLong(this.values[0]);
    }

    @Override
    public void setGenericDouble1(double x) {
        this.values[1] = (long)x;
    }

    @Override
    public double getGenericDouble1() {
        return this.values[1];
    }

    @Override
    public void setDouble1(double x) {
        this.values[1] = (long)x;
    }

    @Override
    public double getDouble1() {
        return this.values[1];
    }

    @Override
    public void set1(Value x) {
        this.values[1] = x.getRawValue();
    }

    @Override
    public Value get1() {
        return Value.createFromRawLong(this.values[1]);
    }

    @Override
    public void setGenericDouble2(double x) {
        this.values[2] = (long)x;
    }

    @Override
    public double getGenericDouble2() {
        return this.values[2];
    }

    @Override
    public void setDouble2(double x) {
        this.values[2] = (long)x;
    }

    @Override
    public double getDouble2() {
        return this.values[2];
    }

    @Override
    public void set2(Value x) {
        this.values[2] = x.getRawValue();
    }

    @Override
    public Value get2() {
        return Value.createFromRawLong(this.values[2]);
    }

    @Override
    public void setGenericDouble3(double x) {
        this.values[3] = (long)x;
    }

    @Override
    public double getGenericDouble3() {
        return this.values[3];
    }

    @Override
    public void setDouble3(double x) {
        this.values[3] = (long)x;
    }

    @Override
    public double getDouble3() {
        return this.values[3];
    }

    @Override
    public void set3(Value x) {
        this.values[3] = x.getRawValue();
    }

    @Override
    public Value get3() {
        return Value.createFromRawLong(this.values[3]);
    }

    @Override
    public void setGenericDouble4(double x) {
        this.values[4] = (long)x;
    }

    @Override
    public double getGenericDouble4() {
        return this.values[4];
    }

    @Override
    public void setDouble4(double x) {
        this.values[4] = (long)x;
    }

    @Override
    public double getDouble4() {
        return this.values[4];
    }

    @Override
    public void set4(Value x) {
        this.values[4] = x.getRawValue();
    }

    @Override
    public Value get4() {
        return Value.createFromRawLong(this.values[4]);
    }

    @Override
    public void setGenericDouble5(double x) {
        this.values[5] = (long)x;
    }

    @Override
    public double getGenericDouble5() {
        return this.values[5];
    }

    @Override
    public void setDouble5(double x) {
        this.values[5] = (long)x;
    }

    @Override
    public double getDouble5() {
        return this.values[5];
    }

    @Override
    public void set5(Value x) {
        this.values[5] = x.getRawValue();
    }

    @Override
    public Value get5() {
        return Value.createFromRawLong(this.values[5]);
    }

    @Override
    public void setGenericDouble6(double x) {
        this.values[6] = (long)x;
    }

    @Override
    public double getGenericDouble6() {
        return this.values[6];
    }

    @Override
    public void setDouble6(double x) {
        this.values[6] = (long)x;
    }

    @Override
    public double getDouble6() {
        return this.values[6];
    }

    @Override
    public void set6(Value x) {
        this.values[6] = x.getRawValue();
    }

    @Override
    public Value get6() {
        return Value.createFromRawLong(this.values[6]);
    }

    @Override
    public void setGenericDouble7(double x) {
        this.values[7] = (long)x;
    }

    @Override
    public double getGenericDouble7() {
        return this.values[7];
    }

    @Override
    public void setDouble7(double x) {
        this.values[7] = (long)x;
    }

    @Override
    public double getDouble7() {
        return this.values[7];
    }

    @Override
    public void set7(Value x) {
        this.values[7] = x.getRawValue();
    }

    @Override
    public Value get7() {
        return Value.createFromRawLong(this.values[7]);
    }
}

