/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ocamljava.runtime.annotations.parameters.Parameters;
import org.ocamljava.runtime.annotations.primitives.AbstractPrimitivesConverter;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.ContextWithoutRuntimeLock;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.MarshalExtern;
import org.ocamljava.runtime.values.Value;

public final class Primitives2Marshalled
extends AbstractPrimitivesConverter {
    private final FileOutputStream out;
    private final List<Value> values;

    private Primitives2Marshalled(String b, String f) throws IOException {
        super(b, null);
        assert (f != null) : "null f";
        this.out = new FileOutputStream(f);
        this.values = new ArrayList<Value>();
    }

    @Override
    protected void beforeWalk() {
        this.values.clear();
    }

    @Override
    protected void visitClass(String className) {
        try {
            Class<?> cl = Class.forName(className);
            PrimitiveProvider prov = cl.getAnnotation(PrimitiveProvider.class);
            if (prov != null) {
                ArrayList<String> meths = new ArrayList<String>();
                for (Method meth : cl.getDeclaredMethods()) {
                    Primitive prim = meth.getAnnotation(Primitive.class);
                    if (prim == null) continue;
                    meths.add(meth.getName());
                }
                int sz = meths.size();
                Value v = Value.createBlock(0, sz);
                for (int i = 0; i < sz; ++i) {
                    v.set(i, Value.createString((String)meths.get(i)));
                }
                this.values.add(Value.createBlock(0, Value.createString(className), v));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void afterWalk() {
    }

    private void write() throws IOException {
        int len = this.values.size();
        Value content = Value.createBlock(0, len);
        for (int i = 0; i < len; ++i) {
            content.set(i, this.values.get(i));
        }
        try {
            ContextWithoutRuntimeLock ctxt = new ContextWithoutRuntimeLock(Parameters.defaultByteCodeParameters(), false, new File("."));
            this.out.write(MarshalExtern.externValue(ctxt, content, Value.EMPTY_LIST));
        }
        catch (Fail.Exception fe) {
            throw new IOException("error in marshalling");
        }
    }

    public static void main(String[] args) {
        PrintStream err = System.err;
        if (args.length == 2) {
            try {
                Primitives2Marshalled p2m = new Primitives2Marshalled(args[0], args[1]);
                p2m.walkFileTree();
                p2m.write();
            }
            catch (IOException ioe) {
                err.printf("i/o error: %s\n", ioe.getMessage());
                System.exit(1);
            }
            System.exit(0);
        } else {
            err.println("error: a path, and a file should be provided");
            System.exit(1);
        }
    }
}

