/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import org.ocamljava.runtime.primitives.stdlib.Hash;
import org.ocamljava.runtime.support.wrappers.ToValue;
import org.ocamljava.runtime.values.Value;

public final class PolymorphicVariant<T extends ToValue>
implements ToValue {
    private final String name;
    private final T value;

    public PolymorphicVariant(String n, T v) {
        assert (n != null) : "null n";
        assert (v != null) : "null v";
        this.name = n;
        this.value = v;
    }

    public PolymorphicVariant(String n) {
        assert (n != null) : "null n";
        this.name = n;
        this.value = null;
    }

    @Override
    public Value toValue() {
        if (this.value != null) {
            return Value.createBlock(0, Hash.hashVariant(this.name), this.value.toValue());
        }
        return Hash.hashVariant(this.name);
    }

    public int hashCode() {
        return this.name.hashCode() + (this.value != null ? this.value.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PolymorphicVariant) {
            PolymorphicVariant that = (PolymorphicVariant)obj;
            return this.name.equals(that.name) && (this.value == null && that.value == null || this.value != null && this.value.equals(that.value));
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("`");
        sb.append(this.name);
        if (this.value != null) {
            sb.append(" (");
            sb.append(this.value.toString());
            sb.append(")");
        }
        return sb.toString();
    }
}

