/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicInt64", source="")
public final class AtomicInt64 {
    private AtomicInt64() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int64"}, returnType="AtomicInt64.t")
    public static Value ocamljava_atomicint64_make(Value initialValue) {
        return Value.createInstance(new AtomicLong(initialValue.asInt64()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64_add_and_get(Value obj, Value delta) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        long res = inst.addAndGet(delta.asInt64());
        return Value.createInt64(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64", "int64"}, returnType="bool")
    public static Value ocamljava_atomicint64_compare_and_set(Value obj, Value expect, Value update) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        boolean res = inst.compareAndSet(expect.asInt64(), update.asInt64());
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_decrement_and_get(Value obj) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        long res = inst.decrementAndGet();
        return Value.createInt64(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_get(Value obj) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        long res = inst.get();
        return Value.createInt64(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64_get_and_add(Value obj, Value delta) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        long res = inst.getAndAdd(delta.asInt64());
        return Value.createInt64(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_get_and_decrement(Value obj) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        long res = inst.getAndDecrement();
        return Value.createInt64(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_get_and_increment(Value obj) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        long res = inst.getAndIncrement();
        return Value.createInt64(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="int64")
    public static Value ocamljava_atomicint64_get_and_set(Value obj, Value newValue) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        long res = inst.getAndSet(newValue.asInt64());
        return Value.createInt64(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t"}, returnType="int64")
    public static Value ocamljava_atomicint64_increment_and_get(Value obj) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        long res = inst.incrementAndGet();
        return Value.createInt64(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="unit")
    public static Value ocamljava_atomicint64_lazy_set(Value obj, Value newValue) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        inst.lazySet(newValue.asInt64());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64"}, returnType="unit")
    public static Value ocamljava_atomicint64_set(Value obj, Value newValue) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        inst.set(newValue.asInt64());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt64.t", "int64", "int64"}, returnType="bool")
    public static Value ocamljava_atomicint64_weak_compare_and_set(Value obj, Value expect, Value update) {
        AtomicLong inst = (AtomicLong)obj.asCustom();
        boolean res = inst.weakCompareAndSet(expect.asInt64(), update.asInt64());
        return res ? Value.TRUE : Value.FALSE;
    }
}

