/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.values.Value;

public final class Primitives {
    private static final String INVALID_PROVIDER = "'%s' is not a valid primive provider";
    private static final String PRIM_DEF_TWICE = "'%s' primive defined twice";
    private static final String NO_IMPLEMENTATION = "no implementation for '%s' primitive";
    private static final Class<PrimitiveProvider> PRIMITIVE_PROVIDER_ANNOT = PrimitiveProvider.class;
    private static final Class<Primitive> PRIMITIVE_ANNOT = Primitive.class;

    private Primitives() {
    }

    public static Method lookupPrimitive(String primName, Class<?> ... classes) throws OCamlJavaException {
        assert (primName != null) : "null primName";
        assert (classes != null) : "null classes";
        for (Class<?> cl : classes) {
            if (cl.getAnnotation(PRIMITIVE_PROVIDER_ANNOT) == null) continue;
            for (Method m : cl.getDeclaredMethods()) {
                if (!m.getName().equals(primName) || !Primitives.checkMethod(m)) continue;
                return m;
            }
        }
        throw new OCamlJavaException(String.format(NO_IMPLEMENTATION, primName));
    }

    public static void loadAllPrimitives(Map<String, Method> prims, Class<?> cl) throws OCamlJavaException {
        assert (prims != null) : "null prims";
        assert (cl != null) : "null cl";
        if (cl.getAnnotation(PRIMITIVE_PROVIDER_ANNOT) != null) {
            for (Method m : cl.getDeclaredMethods()) {
                String primName = m.getName();
                if (!Primitives.checkMethod(m) || prims.put(primName, m) == null) continue;
                throw new OCamlJavaException(String.format(PRIM_DEF_TWICE, primName));
            }
        } else {
            throw new OCamlJavaException(String.format(INVALID_PROVIDER, cl.getName()));
        }
    }

    private static boolean checkMethod(Method m) {
        assert (m != null) : "null m";
        return Modifier.isStatic(m.getModifiers()) && m.getAnnotation(PRIMITIVE_ANNOT) != null && m.getReturnType().equals(Value.class) && Primitives.checkParameters(m.getParameterTypes()) && Primitives.checkExceptions(m.getExceptionTypes());
    }

    private static boolean checkParameters(Class<?>[] types) {
        int i;
        assert (types != null) : "null types";
        int len = types.length;
        for (i = 0; i < len && Value.class.equals(types[i]); ++i) {
        }
        return i == len && len > 0;
    }

    private static boolean checkExceptions(Class<?>[] exceptions) {
        assert (exceptions != null) : "null exceptions";
        for (Class<?> exn : exceptions) {
            if (exn.equals(Fail.Exception.class) || exn.equals(Fatal.Exception.class) || exn.equals(FalseExit.class)) continue;
            return false;
        }
        return true;
    }

    public static Class<?>[] getSPIClasses() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            LinkedList classes = new LinkedList();
            Enumeration<URL> e = cl.getResources("META-INF/services/org.ocamljava.runtime.annotations.primitives.PrimitiveProvider");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                for (String s : Primitives.readClassNames(url)) {
                    try {
                        classes.add(Class.forName(s));
                    }
                    catch (Throwable t) {}
                }
            }
            Class[] res = new Class[classes.size()];
            return classes.toArray(res);
        }
        catch (IOException ioe) {
            return new Class[0];
        }
    }

    private static List<String> readClassNames(URL url) {
        assert (url != null) : "null url";
        LinkedList<String> res = new LinkedList<String>();
        try {
            InputStreamReader isr = new InputStreamReader(url.openStream());
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                int idx = line.indexOf(35);
                if (idx != -1) {
                    line = line.substring(0, idx);
                }
                if ((line = line.trim()).length() != 0) {
                    res.add(line);
                }
                line = br.readLine();
            }
            br.close();
            isr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }
}

