/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import org.ocamljava.runtime.support.wrappers.ToValue;
import org.ocamljava.runtime.values.Value;

public final class MutableString
implements ToValue {
    private final StringBuilder value;

    public MutableString(String v) {
        assert (v != null) : "null v";
        this.value = new StringBuilder(v);
    }

    public MutableString(int sz, char ch) {
        assert (sz >= 0) : "sz should be >= 0";
        this.value = new StringBuilder(sz);
        for (int i = 0; i < sz; ++i) {
            this.value.setCharAt(i, ch);
        }
    }

    public String get() {
        return this.value.toString();
    }

    public char getChar(int index) {
        return this.value.charAt(index);
    }

    public void setChar(int index, char v) {
        this.value.setCharAt(index, v);
    }

    @Override
    public Value toValue() {
        return Value.createString(this.value.toString());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableString) {
            MutableString that = (MutableString)obj;
            return this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        return this.value.toString();
    }
}

