/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.unix;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.otherlibs.unix.Unix;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="unix", module="Unix", source="otherlibs/unix/ftruncate.c")
public final class Ftruncate {
    private Ftruncate() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "int"}, returnType="unit")
    public static Value unix_ftruncate(Value fd, Value len) throws Fail.Exception, FalseExit {
        try {
            Channel ch = CurrentContext.getFilesState().getChannel(fd.asCastedInt());
            if (ch == null) {
                Unix.fail("ftruncate", "invalid descriptor");
                return Value.UNIT;
            }
            ch.truncate(len.asLong());
            return Value.UNIT;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Unix.fail("ftruncate", ioe);
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Unix.file_descr", "int64"}, returnType="unit")
    public static Value unix_ftruncate_64(Value fd, Value len) throws Fail.Exception, FalseExit {
        try {
            Channel ch = CurrentContext.getFilesState().getChannel(fd.asCastedInt());
            if (ch == null) {
                Unix.fail("ftruncate_64", "invalid descriptor");
                return Value.UNIT;
            }
            ch.truncate(len.asInt64());
            return Value.UNIT;
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Unix.fail("ftruncate_64", ioe);
            return Value.UNIT;
        }
    }
}

