/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.TimeoutException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.TimeUnit;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Phaser", source="")
public final class Phaser {
    private Phaser() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t option", "int32"}, returnType="Phaser.t")
    public static Value ocamljava_phaser_make(Value parent, Value parties) throws Fail.Exception {
        java.util.concurrent.Phaser p = parent.isLong() ? null : (java.util.concurrent.Phaser)parent.get0().asCustom();
        try {
            return Value.createInstance(new java.util.concurrent.Phaser(p, parties.asInt32()));
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Phaser.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_arrive(Value obj) throws Fail.Exception {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        try {
            int res = inst.arrive();
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Phaser.arrive");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_arrive_and_await_advance(Value obj) throws Fail.Exception {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        try {
            int res = inst.arriveAndAwaitAdvance();
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Phaser.arrive_and_await_advance");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_arrive_and_deregister(Value obj) throws Fail.Exception {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        try {
            int res = inst.arriveAndDeregister();
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Phaser.arrive_and_deregister");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t", "int32"}, returnType="int32")
    public static Value ocamljava_phaser_await_advance(Value obj, Value phase) {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        int res = inst.awaitAdvance(phase.asInt32());
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t", "int32"}, returnType="int32")
    public static Value ocamljava_phaser_await_advance_interruptibly(Value obj, Value phase) throws Fail.Exception {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        try {
            int res = inst.awaitAdvanceInterruptibly(phase.asInt32());
            return Value.createInt32(res);
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Phaser.await_advance_interruptibly");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t", "int32", "int64", "TimeUnit.t"}, returnType="int32")
    public static Value ocamljava_phaser_await_advance_interruptibly_time(Value obj, Value phase, Value timeout, Value unit) throws Fail.Exception {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        try {
            int res = inst.awaitAdvanceInterruptibly(phase.asInt32(), timeout.asInt64(), TimeUnit.decode(unit));
            return Value.createInt32(res);
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Phaser.await_advance_interruptibly_time");
            return Value.UNIT;
        }
        catch (TimeoutException te) {
            Runtime.raiseTimeout("Concurrent.Phaser.await_advance_interruptibly_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t", "int32"}, returnType="int32")
    public static Value ocamljava_phaser_bulk_register(Value obj, Value parties) throws Fail.Exception {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        try {
            int res = inst.bulkRegister(parties.asInt32());
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Phaser.bulk_register");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="unit")
    public static Value ocamljava_phaser_force_termination(Value obj) {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        inst.forceTermination();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_get_arrived_parties(Value obj) {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        int res = inst.getArrivedParties();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="Phaser.t option")
    public static Value ocamljava_phaser_get_parent(Value obj) {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        java.util.concurrent.Phaser res = inst.getParent();
        return res == null ? Value.ZERO : Value.createBlock(0, Value.createInstance(res));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_get_phase(Value obj) {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        int res = inst.getPhase();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_get_registered_parties(Value obj) {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        int res = inst.getRegisteredParties();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="Phaser.t")
    public static Value ocamljava_phaser_get_root(Value obj) {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        java.util.concurrent.Phaser res = inst.getParent();
        return Value.createInstance(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_get_unarrived_parties(Value obj) {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        int res = inst.getUnarrivedParties();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="bool")
    public static Value ocamljava_phaser_is_terminated(Value obj) {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        boolean res = inst.isTerminated();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Phaser.t"}, returnType="int32")
    public static Value ocamljava_phaser_register(Value obj) throws Fail.Exception {
        java.util.concurrent.Phaser inst = (java.util.concurrent.Phaser)obj.asCustom();
        try {
            int res = inst.register();
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Phaser.register");
            return Value.UNIT;
        }
    }
}

