/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.javalibs.concurrent.Runtime;
import org.ocamljava.runtime.primitives.javalibs.concurrent.SimpleThread;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="Thread", source="")
public final class Thread {
    private Thread() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t option", "string option", "('a -> unit)", "'a"}, returnType="Thread.t")
    public static Value ocamljava_thread_make(Value group, Value name, Value closure, Value parameter) {
        ThreadGroup g = group.isLong() ? null : (ThreadGroup)group.get0().asCustom();
        String n = name.isLong() ? "" : name.get0().asString();
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        SimpleThread t = new SimpleThread(g, n, runner, closure, parameter);
        return Value.createInstance(t);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="Thread.t")
    public static Value ocamljava_thread_current_thread(Value unit) {
        java.lang.Thread res = java.lang.Thread.currentThread();
        return Value.createInstance(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="string")
    public static Value ocamljava_thread_get_id(Value obj) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        long res = inst.getId();
        return Value.createInt64(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="string")
    public static Value ocamljava_thread_get_name(Value obj) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        String res = inst.getName();
        return Value.createString(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="int32")
    public static Value ocamljava_thread_get_priority(Value obj) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        int res = inst.getPriority();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="Thread.state")
    public static Value ocamljava_thread_get_state(Value obj) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        Thread.State res = inst.getState();
        return Thread.encode(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="ThreadGroup.t option")
    public static Value ocamljava_thread_get_thread_group(Value obj) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        ThreadGroup res = inst.getThreadGroup();
        return res == null ? Value.ZERO : Value.createBlock(0, Value.createInstance(res));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value ocamljava_thread_interrupt(Value obj) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        inst.interrupt();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="bool")
    public static Value ocamljava_thread_interrupted(Value unit) {
        return java.lang.Thread.interrupted() ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="bool")
    public static Value ocamljava_thread_is_alive(Value obj) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        boolean res = inst.isAlive();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="bool")
    public static Value ocamljava_thread_is_daemon(Value obj) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        boolean res = inst.isDaemon();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="bool")
    public static Value ocamljava_thread_is_interrupted(Value obj) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        boolean res = inst.isInterrupted();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value ocamljava_thread_join(Value obj) throws Fail.Exception {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        try {
            inst.join();
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Thread.join");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "int64"}, returnType="unit")
    public static Value ocamljava_thread_join_time(Value obj, Value millis) throws Fail.Exception {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        try {
            inst.join(millis.asInt64());
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Thread.join_time");
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Thread.join_time");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "int64", "int32"}, returnType="unit")
    public static Value ocamljava_thread_join_time_nanos(Value obj, Value millis, Value nanos) throws Fail.Exception {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        try {
            inst.join(millis.asInt64(), nanos.asInt32());
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Thread.join_time_nanos");
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Thread.join_time_nanos");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "string"}, returnType="unit")
    public static Value ocamljava_thread_set_daemon(Value obj, Value on) throws Fail.Exception {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        try {
            inst.setDaemon(on != Value.FALSE);
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Thread.set_daemon");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "string"}, returnType="unit")
    public static Value ocamljava_thread_set_name(Value obj, Value name) {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        inst.setName(name.asString());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t", "int32"}, returnType="unit")
    public static Value ocamljava_thread_set_priority(Value obj, Value newPriority) throws Fail.Exception {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        try {
            inst.setPriority(newPriority.asInt32());
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Thread.set_priority");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int64"}, returnType="unit")
    public static Value ocamljava_thread_sleep(Value millis) throws Fail.Exception {
        try {
            java.lang.Thread.sleep(millis.asInt64());
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Thread.sleep");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int64", "int32"}, returnType="unit")
    public static Value ocamljava_thread_sleep_nanos(Value millis, Value nanos) throws Fail.Exception {
        try {
            java.lang.Thread.sleep(millis.asInt64(), nanos.asInt32());
            return Value.UNIT;
        }
        catch (InterruptedException ie) {
            Runtime.raiseInterrupted("Concurrent.Thread.sleep_nanos");
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Thread.sleep_nanos");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"Thread.t"}, returnType="unit")
    public static Value ocamljava_thread_start(Value obj) throws Fail.Exception {
        java.lang.Thread inst = (java.lang.Thread)obj.asCustom();
        try {
            inst.start();
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.invalidArgument("Concurrent.Thread.start");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="unit")
    public static Value ocamljava_thread_yield(Value unit) {
        java.lang.Thread.yield();
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int32")
    public static Value ocamljava_thread_get_max_priority(Value unit) {
        return Value.createInt32(10);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int32")
    public static Value ocamljava_thread_get_min_priority(Value unit) {
        return Value.createInt32(1);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"unit"}, returnType="int32")
    public static Value ocamljava_thread_get_norm_priority(Value unit) {
        return Value.createInt32(5);
    }

    static Value encode(Thread.State x) {
        switch (x) {
            case NEW: {
                return Value.ZERO;
            }
            case RUNNABLE: {
                return Value.ONE;
            }
            case BLOCKED: {
                return Value.TWO;
            }
            case WAITING: {
                return Value.THREE;
            }
            case TIMED_WAITING: {
                return Value.FOUR;
            }
            case TERMINATED: {
                return Value.FIVE;
            }
        }
        assert (false) : "should not happen";
        return null;
    }
}

