/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

public final class LargeStringValue
extends BlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private long sizeTagged;
    private long sizeMinusOneTagged;
    private Value sizeWrapped;
    private byte[][] bytes;

    LargeStringValue(long sz) {
        super(252, (sz + 8L) / 8L);
        assert (sz >= 0L) : "sz should be >= 0";
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.sizeTagged = this.length << 1 | 1L;
        this.sizeMinusOneTagged = this.length - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(this.length);
        this.bytes = new byte[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.bytes[i] = new byte[Integer.MIN_VALUE];
        }
        this.bytes[len - 1] = new byte[lenLast];
    }

    LargeStringValue(long sz, String s) {
        this(sz);
        assert (sz >= 0L) : "sz should be >= 0";
        assert (s != null) : "null s";
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            this.setByte(i, EncodingUtils.convertCharToByte(s.charAt(i)));
        }
    }

    LargeStringValue(long sz, byte[] s) {
        this(sz);
        assert (sz >= 0L) : "sz should be >= 0";
        assert (s != null) : "null s";
        int l = s.length;
        for (int i = 0; i < l; ++i) {
            this.setByte(i, s[i]);
        }
    }

    @Override
    public synchronized String asString() {
        StringBuilder res = new StringBuilder();
        int len = (int)Math.min(this.length, 0x7FFFFFFEL);
        for (int i = 0; i < len; ++i) {
            res.append(EncodingUtils.convertByteToChar(this.getByte(i)));
        }
        return res.toString();
    }

    @Override
    public byte[] getBytes() {
        assert (false) : "cannot be called on a LargeStringValue";
        return null;
    }

    @Override
    public synchronized byte[] getBytesForModification() {
        assert (false) : "cannot be called on a LargeStringValue";
        return null;
    }

    @Override
    public int[] getUnsignedBytes() {
        assert (false) : "cannot be called on a LargeStringValue";
        return null;
    }

    @Override
    public byte getByte(long idx) throws ArrayIndexOutOfBoundsException {
        if (idx == this.length) {
            return 0;
        }
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        return this.bytes[idx1][idx2];
    }

    @Override
    public void setByte(long idx, byte x) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        this.bytes[idx1][idx2] = x;
    }

    @Override
    public int getUnsignedByte(long idx) throws ArrayIndexOutOfBoundsException {
        return IntegerUtils.signedToUnsignedByte(this.getByte(idx));
    }

    @Override
    public void setUnsignedByte(long idx, int x) throws ArrayIndexOutOfBoundsException {
        this.setByte(idx, (byte)IntegerUtils.unsignedToSignedByte(x & 0xFF));
    }

    @Override
    public long sizeBytes() {
        return this.length;
    }

    @Override
    public long sizeBytesTagged() {
        return this.sizeTagged;
    }

    @Override
    public long sizeBytesMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value sizeBytesWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long s) {
        long sz = s * 8L;
        byte[][] oldBytes = this.bytes;
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.sizeTagged = sz << 1 | 1L;
        this.sizeMinusOneTagged = sz - 1L << 1 | 1L;
        this.sizeWrapped = Value.createLong(sz);
        this.bytes = new byte[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.bytes[i] = new byte[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.bytes[i][j] = oldBytes[i][j];
            }
        }
        this.bytes[len - 1] = new byte[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.bytes[len - 1][j] = oldBytes[len - 1][j];
        }
    }

    @Override
    public void copy(BlockValue src) {
        long len = Math.min(this.length, src.sizeValues());
        for (long i = 0L; i < len; ++i) {
            this.setByte(i, src.getByte(i));
        }
    }

    @Override
    public LargeStringValue duplicate() {
        long len = this.length;
        LargeStringValue res = new LargeStringValue(len);
        for (long i = 0L; i < len; ++i) {
            res.setByte(i, this.getByte(i));
        }
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public int hashCode() {
        int res = 0;
        byte[] v = this.bytes[0];
        int len = Math.min(32, v.length);
        for (int i = 0; i < len; ++i) {
            res += v[i];
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LargeStringValue) {
            LargeStringValue that = (LargeStringValue)obj;
            int lenThis = this.bytes.length;
            int lenThat = that.bytes.length;
            if (lenThis == lenThis) {
                int i;
                for (i = 0; i < lenThis && Arrays.equals(this.bytes[i], that.bytes[i]); ++i) {
                }
                return i == lenThis;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LargeStringValue(");
        int len = this.bytes.length;
        for (int i = 0; i < len; ++i) {
            int l = this.bytes[i].length;
            for (int j = 0; j < l; ++j) {
                if (i + j != 0) {
                    sb.append(", ");
                }
                sb.append(this.bytes[i][j]);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void set(Value x, long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(Value, long) called on an instance of " + this.getClass();
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "get(int) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get0() {
        assert (false) : "get0() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get1() {
        assert (false) : "get1() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get2() {
        assert (false) : "get2() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get3() {
        assert (false) : "get3() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get4() {
        assert (false) : "get4() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get5() {
        assert (false) : "get5() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get6() {
        assert (false) : "get6() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Value get7() {
        assert (false) : "get7() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "set(int, Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set0(Value x) {
        assert (false) : "set0(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set1(Value x) {
        assert (false) : "set1(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set2(Value x) {
        assert (false) : "set2(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set3(Value x) {
        assert (false) : "set3(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set4(Value x) {
        assert (false) : "set4(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set5(Value x) {
        assert (false) : "set5(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set6(Value x) {
        assert (false) : "set6(Value) called on an instance of " + this.getClass();
    }

    @Override
    public void set7(Value x) {
        assert (false) : "set7(Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeValues() {
        assert (false) : "sizeValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLength() {
        assert (false) : "arrayLength() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLengthTagged() {
        assert (false) : "arrayLengthTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        assert (false) : "arrayLengthMinusOneTagged() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public Value arrayLengthWrapped() {
        assert (false) : "arrayLengthWrapped() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public int asInt32() {
        assert (false) : "asInt32() called on an instance of " + this.getClass();
        return 0;
    }

    @Override
    public void setInt32(int v) {
        assert (false) : "setInt32(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asInt64() {
        assert (false) : "asInt64() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setInt64(long v) {
        assert (false) : "setInt64(int) called on an instance of " + this.getClass();
    }

    @Override
    public long asNativeInt() {
        assert (false) : "asNativeInt() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setNativeInt(long v) {
        assert (false) : "setNativeInt(long) called on an instance of " + this.getClass();
    }

    @Override
    public double asDouble() {
        assert (false) : "asDouble() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(double d) {
        assert (false) : "setDouble(double) called on an instance of " + this.getClass();
    }

    @Override
    public CustomOperations getCustomOperations() {
        assert (false) : "getCustomOperations() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public Object asCustom() {
        assert (false) : "asCustom() called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setCustom(Object o) {
        assert (false) : "setCustom(Object) called on an instance of " + this.getClass();
    }

    @Override
    public long getCode() {
        assert (this.getTag() == 247 || this.getTag() == 249) : "getCode() called on an instance of " + this.getClass();
        return this.get0().asCodeOffset();
    }

    @Override
    public void setCode(long code) {
        assert (this.getTag() == 247 || this.getTag() == 249) : "setCode(long) called on an instance of " + this.getClass();
        this.set0(Value.createCodeOffset(code));
    }

    @Override
    public int asCastedInt() {
        return -1;
    }

    @Override
    public int asBoundedInt() throws Fatal.Exception {
        return -1;
    }

    @Override
    public long getRawLong(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(long) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getRawLong(int) called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong0() {
        assert (false) : "getRawLong0() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong1() {
        assert (false) : "getRawLong1() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong2() {
        assert (false) : "getRawLong2() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong3() {
        assert (false) : "getRawLong3() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong4() {
        assert (false) : "getRawLong4() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong5() {
        assert (false) : "getRawLong5() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong6() {
        assert (false) : "getRawLong6() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public long getRawLong7() {
        assert (false) : "getRawLong7() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setRawLong(long idx, long x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(long, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong(int idx, long x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setRawLong(int, long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong0(long x) {
        assert (false) : "setRawLong0(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong1(long x) {
        assert (false) : "setRawLong1(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong2(long x) {
        assert (false) : "setRawLong2(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong3(long x) {
        assert (false) : "setRawLong3(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong4(long x) {
        assert (false) : "setRawLong4(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong5(long x) {
        assert (false) : "setRawLong5(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong6(long x) {
        assert (false) : "setRawLong6(long) called on an instance of " + this.getClass();
    }

    @Override
    public void setRawLong7(long x) {
        assert (false) : "setRawLong7(long) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeLongs() {
        assert (false) : "sizeLongs() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getDouble(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble0() {
        assert (false) : "getDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble1() {
        assert (false) : "getDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble2() {
        assert (false) : "getDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble3() {
        assert (false) : "getDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble4() {
        assert (false) : "getDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble5() {
        assert (false) : "getDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble6() {
        assert (false) : "getDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getDouble7() {
        assert (false) : "getDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble0(double x) {
        assert (false) : "setDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble1(double x) {
        assert (false) : "setDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble2(double x) {
        assert (false) : "setDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble3(double x) {
        assert (false) : "setDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble4(double x) {
        assert (false) : "setDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble5(double x) {
        assert (false) : "setDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble6(double x) {
        assert (false) : "setDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setDouble7(double x) {
        assert (false) : "setDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeDoubles() {
        assert (false) : "sizeDoubles() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public double getGenericDouble(long idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(long) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble(int idx) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getGenericDouble(int) called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble0() {
        assert (false) : "getGenericDouble0() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble1() {
        assert (false) : "getGenericDouble1() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble2() {
        assert (false) : "getGenericDouble2() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble3() {
        assert (false) : "getGenericDouble3() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble4() {
        assert (false) : "getGenericDouble4() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble5() {
        assert (false) : "getGenericDouble5() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble6() {
        assert (false) : "getGenericDouble6() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public double getGenericDouble7() {
        assert (false) : "getGenericDouble7() called on an instance of " + this.getClass();
        return 0.0;
    }

    @Override
    public void setGenericDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(long, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setGenericDouble(int, double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble0(double x) {
        assert (false) : "setGenericDouble0(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble1(double x) {
        assert (false) : "setGenericDouble1(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble2(double x) {
        assert (false) : "setGenericDouble2(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble3(double x) {
        assert (false) : "setGenericDouble3(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble4(double x) {
        assert (false) : "setGenericDouble4(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble5(double x) {
        assert (false) : "setGenericDouble5(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble6(double x) {
        assert (false) : "setGenericDouble6(double) called on an instance of " + this.getClass();
    }

    @Override
    public void setGenericDouble7(double x) {
        assert (false) : "setGenericDouble7(double) called on an instance of " + this.getClass();
    }

    @Override
    public Value getWeak(long i) throws ArrayIndexOutOfBoundsException {
        assert (false) : "getWeak(long) called on an instance of " + this.getClass();
        return null;
    }

    @Override
    public void setWeak(long i, Value v) throws ArrayIndexOutOfBoundsException {
        assert (false) : "setWeak(long, Value) called on an instance of " + this.getClass();
    }

    @Override
    public long sizeWeakValues() {
        assert (false) : "sizeWeakValues() called on an instance of " + this.getClass();
        return 0L;
    }

    @Override
    public void setParent(BlockValue b) {
        assert (false) : "setParent(BlockValue) called on an instance of " + this.getClass();
    }

    @Override
    public BlockValue getParent() {
        assert (false) : "getParent() called on an instance of " + this.getClass();
        return null;
    }
}

