/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.context;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.ocamljava.runtime.annotations.primitives.Primitives;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Dispatcher;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.OCamlJavaException;
import org.ocamljava.runtime.parameters.CommonParameters;
import org.ocamljava.runtime.util.CustomClassLoader;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.JarClassLoader;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.PredefinedCustomOperations;
import org.ocamljava.runtime.values.Value;

public final class CodeState {
    private static final String DUMMY_LIB_NAME = "[OCaml-Java-Internal]";
    private static final int NB_ATOMS = 256;
    private static final String NO_FILE = "";
    private final Context context;
    private final Value[] atoms;
    private final boolean isNative;
    private final String file;
    private int[] code;
    private int originalCodeSize;
    private int[] savedCode;
    private int callbackTail;
    private byte[] codeDigest;
    private final Map<String, CustomOperations> customs;
    private final Map<Object, Object> slots;
    private final Map<String, Value> callbacks;
    private Value globalData;
    private Value debugInfo;
    private boolean backtraceActive;
    private Class<?>[] providers;
    private Dispatcher dispatcher;
    private final Map<String, List<Class<?>>> libraries;
    private boolean parserTrace;
    private final long start;
    private final JarClassLoader classLoader;
    private final List<Fragment> fragments;

    CodeState(Context ctxt, CommonParameters p, boolean nat) {
        assert (ctxt != null) : "null ctxt";
        assert (p != null) : "null p";
        this.context = ctxt;
        this.isNative = nat;
        this.file = p.getFile() != null ? p.getFile() : NO_FILE;
        this.atoms = new Value[256];
        for (int i = 0; i < 256; ++i) {
            this.atoms[i] = Value.createAtom(i);
        }
        this.code = new int[0];
        this.savedCode = null;
        this.codeDigest = null;
        this.customs = new HashMap<String, CustomOperations>();
        this.registerCustom(PredefinedCustomOperations.INT_32_OPS);
        this.registerCustom(PredefinedCustomOperations.INT_NAT_OPS);
        this.registerCustom(PredefinedCustomOperations.INT_64_OPS);
        this.registerCustom(PredefinedCustomOperations.CHANNEL_OPS);
        this.registerCustom(PredefinedCustomOperations.JAVA_OPS);
        this.slots = new HashMap<Object, Object>();
        this.start = System.currentTimeMillis();
        this.callbacks = new HashMap<String, Value>();
        this.callbackTail = -1;
        this.globalData = null;
        this.debugInfo = Value.FALSE;
        this.backtraceActive = p.isBacktraceRequested();
        this.providers = Primitives.getSPIClasses();
        this.dispatcher = null;
        this.libraries = new LinkedHashMap();
        this.libraries.put(DUMMY_LIB_NAME, null);
        this.parserTrace = false;
        this.classLoader = nat ? new JarClassLoader(this.getClass().getClassLoader()) : null;
        this.fragments = new ArrayList<Fragment>();
    }

    public boolean isNative() {
        return this.isNative;
    }

    public String getFile() {
        return this.file;
    }

    public Value getAtom(int atm) {
        assert (atm >= 0 && atm < 256) : "invalid atm";
        return this.atoms[atm];
    }

    public boolean isAtom(Value val) {
        assert (val != null) : "null val";
        if (val.isBlock()) {
            int i;
            for (i = 0; i < 256 && this.atoms[i] != val; ++i) {
            }
            return i < 256;
        }
        return false;
    }

    public int[] getCode() {
        return this.code;
    }

    public int appendCode(int[] additCode) {
        assert (additCode != null) : "null additCode";
        int addLen = additCode.length;
        int oldLen = this.code.length;
        int newLen = oldLen + addLen;
        int[] newCode = new int[newLen];
        System.arraycopy(this.code, 0, newCode, 0, oldLen);
        System.arraycopy(additCode, 0, newCode, oldLen, addLen);
        this.code = newCode;
        if (oldLen == 0) {
            this.originalCodeSize = newLen;
        }
        if (this.context.getDebuggerState().isDebuggerInUse() && oldLen == 0) {
            this.savedCode = new int[newLen];
            System.arraycopy(this.code, 0, this.savedCode, 0, newLen);
        }
        return oldLen;
    }

    public int getOriginalCodeSize() {
        return this.originalCodeSize;
    }

    public int[] getSavedCode() {
        return this.savedCode;
    }

    public void setupCallbackTail() {
        this.callbackTail = this.appendCode(new int[]{19, 1, 143});
    }

    public int getCallbackTail() {
        return this.callbackTail;
    }

    public void setCodeDigest(byte[] digest) {
        assert (digest != null) : "null digest";
        byte[] d = Arrays.copyOf(digest, digest.length);
        this.codeDigest = d;
        this.fragments.add(new Fragment(0, this.code.length, d));
    }

    public byte[] getCodeDigest() {
        return Arrays.copyOf(this.codeDigest, this.codeDigest.length);
    }

    public void registerCustom(CustomOperations ops) {
        assert (ops != null) : "null ops";
        this.customs.put(ops.getIdentifier(), ops);
    }

    public CustomOperations findCustom(String id) {
        assert (id != null) : "null id";
        return this.customs.get(id);
    }

    public void registerSlot(Object slot, Object value) {
        assert (slot != null) : "null slot";
        this.slots.put(slot, value);
    }

    public Object getSlot(Object slot) {
        assert (slot != null) : "null slot";
        return this.slots.get(slot);
    }

    public void removeSlot(Object slot) {
        assert (slot != null) : "null slot";
        this.slots.remove(slot);
    }

    public long getStart() {
        return this.start;
    }

    public void registerCallback(String s, Value v) {
        assert (s != null) : "null s";
        assert (v != null) : "null v";
        this.callbacks.put(s, v);
    }

    public Value getCallback(String s) {
        assert (s != null) : "null s";
        return this.callbacks.get(s);
    }

    public Value getGlobalData() {
        return this.globalData;
    }

    public void setGlobalData(Value gd) {
        assert (gd != null) : "null gd";
        this.globalData = gd;
    }

    public void resizeGlobalData(long sz) {
        long len = this.globalData.sizeValues();
        if (sz >= len) {
            Value bl = Value.createBlock(0, sz + 256L & 0xFFFFFFFFFFFFFF00L);
            for (long i = 0L; i < len; ++i) {
                bl.set(i, this.globalData.get(i));
            }
            this.globalData = bl;
        }
    }

    public void setDebugInfo(Value di) {
        assert (di != null) : "null di";
        this.debugInfo = di;
    }

    public Value getDebugInfo() {
        return this.debugInfo;
    }

    public boolean isBacktraceActive() {
        return this.backtraceActive;
    }

    public void setBacktraceActive(boolean b) {
        this.backtraceActive = b;
    }

    public void setProviders(Class<?>[] p) {
        assert (p != null) : "null p";
        this.providers = Arrays.copyOf(p, p.length);
    }

    public void setDispatcher(Dispatcher d) {
        assert (d != null) : "null d";
        this.dispatcher = d;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Value openLib(Value filename) throws Fail.Exception {
        String baseName;
        File f;
        assert (filename != null) : "null filename";
        URL url = null;
        if (this.context.getFilesState().getFileHook() != null) {
            String name = this.context.getFilesState().resourceNameFromPath(filename);
            url = this.context.getFilesState().getFileHook().getURL(name);
        }
        if (url == null && (f = this.context.getFilesState().getRealFile(filename)).exists()) {
            try {
                url = f.toURI().toURL();
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
        String name = baseName = filename.asString();
        int cnt = 2;
        while (this.libraries.containsKey(name)) {
            name = baseName + cnt++;
        }
        if (url != null) {
            LinkedList classes = new LinkedList();
            try {
                URLClassLoader loader = new URLClassLoader(new URL[]{url}, (ClassLoader)CustomClassLoader.INSTANCE);
                JarFile jar = new JarFile(this.file);
                Enumeration<JarEntry> it = jar.entries();
                while (it.hasMoreElements()) {
                    JarEntry entry = it.nextElement();
                    String s = entry.getName();
                    if (!s.endsWith(".class") || s.indexOf(36) != -1) continue;
                    String s1 = s.substring(0, name.length() - ".class".length());
                    String s2 = s1.replace('/', '.');
                    try {
                        classes.add(Class.forName(s2, true, loader));
                    }
                    catch (Throwable t) {}
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.libraries.put(name, classes);
            return Value.createAbstract(1L, name);
        }
        try {
            Class<?> cl = Class.forName(name);
            LinkedList l = new LinkedList();
            l.add(cl);
            this.libraries.put(name, l);
            return Value.createAbstract(1L, name);
        }
        catch (Throwable t) {
            Fail.failWith("cannot open library");
            return null;
        }
    }

    public void closeLib(String libname) {
        assert (libname != null) : "null libname";
        if (!libname.equals(DUMMY_LIB_NAME)) {
            this.libraries.remove(libname);
        }
    }

    public Value makeLibsArray() {
        int sz = this.libraries.size();
        Value res = Value.createBlock(0, sz);
        int i = 0;
        for (String e : this.libraries.keySet()) {
            res.set(i++, Value.createAbstract(1L, e));
        }
        return res;
    }

    public Value lookupPrimitive(String libName, String symbName) {
        List<Class<?>> classes;
        assert (libName != null) : "null libName";
        assert (symbName != null) : "null symbName";
        if (this.libraries.containsKey(libName) && (classes = this.libraries.get(libName)) != null) {
            for (Class<?> cl : classes) {
                try {
                    Method m = Primitives.lookupPrimitive(symbName, cl);
                    return Value.createAbstract(1L, m);
                }
                catch (Throwable t) {
                }
            }
        }
        try {
            Method m = Primitives.lookupPrimitive(symbName, this.providers);
            if (m != null) {
                return Value.createAbstract(1L, m);
            }
        }
        catch (OCamlJavaException oCamlJavaException) {
            // empty catch block
        }
        return Value.UNIT;
    }

    public int addPrimitive(String name, Method impl) throws IllegalAccessException {
        assert (name != null) : "null name";
        assert (impl != null) : "null impl";
        return this.dispatcher.addPrimitive(name, impl);
    }

    public boolean isParserTraceEnabled() {
        return this.parserTrace;
    }

    public void setParserTrace(boolean b) {
        this.parserTrace = b;
    }

    public JarClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addFragment(int len, byte[] digest) {
        assert (digest != null) : "null digest";
        byte[] d = Arrays.copyOf(digest, digest.length);
        this.fragments.add(new Fragment(this.code.length, this.code.length + len, d));
    }

    public Fragment getFragment(int ofs) {
        for (Fragment f : this.fragments) {
            if (ofs < f.codeStart || ofs >= f.codeEnd) continue;
            return f;
        }
        return null;
    }

    public Value resolveFragment(byte[] digest, long offset) throws Fatal.Exception {
        for (Fragment f : this.fragments) {
            if (!Arrays.equals(digest, f.codeDigest)) continue;
            return Value.createCodeOffset(IntegerUtils.ensure32s(offset + (long)f.codeStart));
        }
        return null;
    }

    public static final class Fragment {
        public final int codeStart;
        public final int codeEnd;
        public final byte[] codeDigest;

        Fragment(int start, int end, byte[] digest) {
            this.codeStart = start;
            this.codeEnd = end;
            this.codeDigest = digest;
        }
    }
}

