/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class DoubleValue
extends BlockValue {
    private double dbl;

    DoubleValue(double d) {
        super(253, 1L);
        this.dbl = d;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public double asDouble() {
        return this.dbl;
    }

    @Override
    public void setDouble(double d) {
        this.dbl = d;
    }

    @Override
    protected void truncateInstance(long sz) {
    }

    @Override
    public void copy(BlockValue src) {
        this.dbl = src.asDouble();
    }

    @Override
    public DoubleValue duplicate() {
        return new DoubleValue(this.dbl);
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public int hashCode() {
        return (int)Double.doubleToRawLongBits(this.dbl);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleValue) {
            DoubleValue that = (DoubleValue)obj;
            return Double.doubleToRawLongBits(this.dbl) == Double.doubleToRawLongBits(that.dbl);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DoubleValue(");
        sb.append(this.dbl);
        sb.append(")");
        return sb.toString();
    }
}

