/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.wrappers;

import java.awt.Canvas;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.ocamljava.runtime.kernel.Interpreter;
import org.ocamljava.runtime.primitives.otherlibs.graph.CustomImage;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

public final class Helpers {
    private Helpers() {
    }

    public static Value createInt(long x) {
        assert (x >= -4611686018427387904L && x <= 0x3FFFFFFFFFFFFFFFL) : "invalid x";
        return Value.createLong(x);
    }

    public static long readInt(Value x) {
        assert (x != null) : "null x";
        return x.asLong();
    }

    public static Value createInt32(int x) {
        return Value.createInt32(x);
    }

    public static int readInt32(Value x) {
        assert (x != null) : "null x";
        return x.asInt32();
    }

    public static Value createNativeInt(long x) {
        return Value.createNativeInt(x);
    }

    public static long readNativeInt(Value x) {
        assert (x != null) : "null x";
        return x.asNativeInt();
    }

    public static Value createInt64(long x) {
        return Value.createInt64(x);
    }

    public static long readInt64(Value x) {
        assert (x != null) : "null x";
        return x.asInt64();
    }

    public static Value createFloat(double x) {
        return Value.createDouble(x);
    }

    public static double readFloat(Value x) {
        assert (x != null) : "null x";
        return x.asDouble();
    }

    public static Value createString(String x) {
        assert (x != null) : "null x";
        return Value.createString(x);
    }

    public static String readString(Value x) {
        assert (x != null) : "null x";
        return x.asString();
    }

    public static Value createFloatArray(double ... x) {
        assert (x != null) : "null x";
        return Value.createDoubleArray(x);
    }

    public static double[] readFloatArray(Value x) {
        assert (x != null) : "null x";
        int len = (int)x.sizeDoubles();
        double[] res = new double[len];
        for (int i = 0; i < len; ++i) {
            res[i] = x.getDouble(i);
        }
        return res;
    }

    public static Value createFloatRecord(double ... x) {
        assert (x != null) : "null x";
        return Helpers.createFloatArray(x);
    }

    public static double[] readFloatRecord(Value x) {
        assert (x != null) : "null x";
        return Helpers.readFloatArray(x);
    }

    public static double getFloat(Value x, int i) {
        assert (x != null) : "null x";
        return x.getDouble(i);
    }

    public static void setFloat(Value x, int i, double d) {
        assert (x != null) : "null x";
        x.setDouble(i, d);
    }

    public static Value createArray(Value ... x) {
        assert (x != null) : "null x";
        int len = x.length;
        Value res = Value.createBlock(0, len);
        for (int i = 0; i < len; ++i) {
            res.set(i, x[i]);
        }
        return res;
    }

    public static Value[] readArray(Value x) {
        assert (x != null) : "null x";
        int len = (int)x.sizeValues();
        Value[] res = new Value[len];
        for (int i = 0; i < len; ++i) {
            res[i] = x.get(i);
        }
        return res;
    }

    public static Value createTuple(Value ... x) {
        assert (x != null) : "null x";
        return Helpers.createArray(x);
    }

    public static Value[] readTuple(Value x) {
        assert (x != null) : "null x";
        return Helpers.readArray(x);
    }

    public static Value get(Value x, int i) {
        assert (x != null) : "null x";
        return x.get(i);
    }

    public static void set(Value x, int i, Value v) {
        assert (x != null) : "null x";
        assert (v != null) : "null v";
        x.set(i, v);
    }

    public static Value createList(Value ... x) {
        assert (x != null) : "null x";
        Value res = Value.EMPTY_LIST;
        int len = x.length;
        for (int i = len - 1; i >= 0; --i) {
            res = Value.createBlock(0, x[i], res);
        }
        return res;
    }

    public static Value createList(List<Value> x) {
        assert (x != null) : "null x";
        ListIterator<Value> it = x.listIterator(x.size());
        Value res = Value.EMPTY_LIST;
        while (it.hasPrevious()) {
            res = Value.createBlock(0, it.previous(), res);
        }
        return res;
    }

    public static List<Value> readList(Value x) {
        assert (x != null) : "null x";
        LinkedList<Value> res = new LinkedList<Value>();
        for (Value list = x; list != Value.EMPTY_LIST; list = list.get1()) {
            res.add(list.get0());
        }
        return res;
    }

    public static Value createImage(BufferedImage bi) {
        assert (bi != null) : "null bi";
        return Value.createCustom(CustomImage.OPS, 16L, bi);
    }

    public static BufferedImage readImage(Value x) {
        assert (x != null) : "null x";
        return (BufferedImage)x.asCustom();
    }

    public static Frame getFrame(Interpreter interp) {
        assert (interp != null) : "null interp";
        GraphSlot slot = (GraphSlot)interp.getContext().getCodeState().getSlot(GraphSlot.SLOT);
        return slot != null ? slot.getFrame() : null;
    }

    public static Canvas getCanvas(Interpreter interp) {
        assert (interp != null) : "null interp";
        GraphSlot slot = (GraphSlot)interp.getContext().getCodeState().getSlot(GraphSlot.SLOT);
        return slot != null ? slot.getCanvas() : null;
    }

    public static BufferedImage getBuffer(Interpreter interp) {
        assert (interp != null) : "null interp";
        GraphSlot slot = (GraphSlot)interp.getContext().getCodeState().getSlot(GraphSlot.SLOT);
        return slot != null ? slot.getBuffer() : null;
    }
}

