/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class LargeWeakBlockValue
extends BlockValue {
    private static final int BITS = 31;
    private static final int MASK = Integer.MAX_VALUE;
    private long length;
    private WeakReference<Value>[][] values;

    LargeWeakBlockValue(long sz) {
        super(251, sz);
        assert (sz >= 0L) : "sz should be >= 0";
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.values = new WeakReference[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new WeakReference[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.values[i][j] = new WeakReference<Object>(null);
            }
        }
        this.values[len - 1] = new WeakReference[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.values[len - 1][j] = new WeakReference<Object>(null);
        }
    }

    @Override
    public Value getWeak(long idx) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        return (Value)this.values[idx1][idx2].get();
    }

    @Override
    public void setWeak(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        int idx1 = (int)(idx >> 31);
        int idx2 = (int)idx & Integer.MAX_VALUE;
        this.values[idx1][idx2] = new WeakReference<Value>(x);
    }

    @Override
    public long sizeValues() {
        return this.length;
    }

    @Override
    public long sizeWeakValues() {
        return this.length;
    }

    @Override
    protected void truncateInstance(long sz) {
        WeakReference<Value>[][] oldValues = this.values;
        int len = (int)(sz >> 31) + 1;
        int lenLast = (int)sz & Integer.MAX_VALUE;
        this.length = sz;
        this.values = new WeakReference[len][];
        for (int i = 0; i < len - 1; ++i) {
            this.values[i] = new WeakReference[Integer.MIN_VALUE];
            for (int j = 0; j < Integer.MIN_VALUE; ++j) {
                this.values[i][j] = oldValues[i][j];
            }
        }
        this.values[len - 1] = new WeakReference[lenLast];
        for (int j = 0; j < lenLast; ++j) {
            this.values[len - 1][j] = oldValues[len - 1][j];
        }
    }

    @Override
    public void copy(BlockValue src) {
        long len = Math.min(this.length, src.sizeValues());
        for (long i = 0L; i < len; ++i) {
            this.setWeak(i, src.getWeak(i));
        }
    }

    @Override
    public LargeWeakBlockValue duplicate() {
        long len = this.length;
        LargeWeakBlockValue res = new LargeWeakBlockValue(len);
        for (long i = 0L; i < len; ++i) {
            res.setWeak(i, this.getWeak(i));
        }
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[i] = this.getWeak(i);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getWeak(i);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getWeak(i).asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getWeak(i).getRawValue();
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        LargeWeakBlockValue res = new LargeWeakBlockValue(len);
        for (long i = 0L; i < len; ++i) {
            res.setWeak(i, this.getWeak(i + ofs));
        }
        return res;
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.setWeak(destOfs + i, this.getWeak(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.setWeak(destOfs + i, this.getWeak(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        WeakReference<Value>[] v = this.values[0];
        int len = Math.min(32, v.length);
        for (int i = 0; i < len; ++i) {
            res += v[i].hashCode();
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LargeWeakBlockValue) {
            LargeWeakBlockValue that = (LargeWeakBlockValue)obj;
            int lenThis = this.values.length;
            int lenThat = that.values.length;
            if (lenThis == lenThis) {
                int i;
                for (i = 0; i < lenThis && Arrays.equals(this.values[i], that.values[i]); ++i) {
                }
                return i == lenThis;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LargeWeakBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            int l = this.values[i].length;
            for (int j = 0; j < l; ++j) {
                Value v;
                if (i + j != 0) {
                    sb.append(", ");
                }
                sb.append((v = (Value)this.values[i][j].get()) == null ? "null" : v.toString());
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

