/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="ThreadGroup", source="")
public final class ThreadGroup {
    private ThreadGroup() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t option", "string"}, returnType="ThreadGroup.t")
    public static Value ocamljava_threadgroup_make(Value parent, Value name) {
        if (parent.isLong()) {
            return Value.createInstance(new java.lang.ThreadGroup(name.asString()));
        }
        return Value.createInstance(new java.lang.ThreadGroup((java.lang.ThreadGroup)parent.get0().asCustom(), name.asString()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="int32")
    public static Value ocamljava_threadgroup_active_count(Value obj) {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        int res = inst.activeCount();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="int32")
    public static Value ocamljava_threadgroup_active_group_count(Value obj) {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        int res = inst.activeGroupCount();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="unit")
    public static Value ocamljava_threadgroup_destroy(Value obj) throws Fail.Exception {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        try {
            inst.destroy();
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.failWith("ThreadGroup.destroy");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="int32")
    public static Value ocamljava_threadgroup_get_max_priority(Value obj) {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        int res = inst.getMaxPriority();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="string")
    public static Value ocamljava_threadgroup_get_name(Value obj) {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        String res = inst.getName();
        return Value.createString(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="ThreadGroup.t option")
    public static Value ocamljava_threadgroup_get_parent(Value obj) {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        java.lang.ThreadGroup res = inst.getParent();
        return res == null ? Value.ZERO : Value.createBlock(0, Value.createInstance(res));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="unit")
    public static Value ocamljava_threadgroup_interrupt(Value obj) throws Fail.Exception {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        try {
            inst.interrupt();
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.failWith("ThreadGroup.interrupt");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="bool")
    public static Value ocamljava_threadgroup_is_daemon(Value obj) {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        boolean res = inst.isDaemon();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t"}, returnType="bool")
    public static Value ocamljava_threadgroup_is_destroyed(Value obj) {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        boolean res = inst.isDestroyed();
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t", "ThreadGroup.t"}, returnType="bool")
    public static Value ocamljava_threadgroup_parent_of(Value obj, Value group) {
        java.lang.ThreadGroup g;
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        boolean res = inst.parentOf(g = (java.lang.ThreadGroup)group.asCustom());
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t", "bool"}, returnType="unit")
    public static Value ocamljava_threadgroup_set_daemon(Value obj, Value daemon) {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        inst.setDaemon(daemon != Value.FALSE);
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"ThreadGroup.t", "int32"}, returnType="unit")
    public static Value ocamljava_threadgroup_set_max_priority(Value obj, Value pri) {
        java.lang.ThreadGroup inst = (java.lang.ThreadGroup)obj.asCustom();
        inst.setMaxPriority(pri.asInt32());
        return Value.UNIT;
    }
}

