/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.num;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.primitives.otherlibs.num.Nat;
import org.ocamljava.runtime.primitives.stdlib.Hash;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.values.AbstractCustomOperations;
import org.ocamljava.runtime.values.CustomOperations;
import org.ocamljava.runtime.values.Value;

final class CustomNat
extends AbstractCustomOperations {
    static final CustomOperations OPS = new CustomNat();

    private CustomNat() {
        super("_nat", false, false, false, true, true);
    }

    @Override
    public CustomOperations.SerializationSizes serialize(DataOutput out, Value v) throws IOException {
        long[] b = (long[])v.asCustom();
        int len = b.length;
        IO.write32u(out, len);
        for (int i = 0; i < len; ++i) {
            IO.write64s(out, b[i]);
        }
        return new CustomOperations.SerializationSizes(len * 8, len * 8);
    }

    @Override
    public CustomOperations.DeserializedValue deserialize(DataInput in) throws IOException, Fatal.Exception {
        int len = IntegerUtils.ensure32s(IO.read32u(in));
        long[] b = new long[len];
        for (int i = 0; i < len; ++i) {
            b[i] = IO.read64s(in);
        }
        int sz = len * 8;
        Value v = Value.createCustom(OPS, sz, b);
        return new CustomOperations.DeserializedValue(v, sz);
    }

    @Override
    public long hash(Value v) {
        int len = (int)Nat.num_digits_nat(v, Value.ZERO, Value.createLong(v.getWoSize() - 1L)).asLong();
        long[] digits = (long[])v.asCustom();
        int h = 0;
        for (int i = 0; i < len; ++i) {
            long d = digits[i];
            h = Hash.caml_hash_mix_uint32(h, (int)(d & 0xFFFFFFFFL));
            if ((d >>>= 32) == 0L && i + 1 == len) break;
            h = Hash.caml_hash_mix_uint32(h, (int)(d & 0xFFFFFFFFL));
        }
        return h;
    }
}

