/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.ocamljava.runtime.util.EncodingUtils;

public final class InputStreamFromReader
extends InputStream {
    private final Reader source;

    public InputStreamFromReader(Reader r) {
        assert (r != null) : "null r";
        this.source = r;
    }

    @Override
    public int read() throws IOException {
        return EncodingUtils.convertCharToByte((char)this.source.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        char[] ch = new char[b.length];
        int nb = this.source.read(ch);
        EncodingUtils.convertCharsToBytes(ch, b, 0, nb);
        return nb;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        char[] ch = new char[len];
        int nb = this.source.read(ch, off, len);
        EncodingUtils.convertCharsToBytes(ch, b, off, Math.min(nb, len));
        return nb;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.source.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.source.ready() ? 1 : 0;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.source.mark(readlimit);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws IOException {
        this.source.reset();
    }

    @Override
    public boolean markSupported() {
        return this.source.markSupported();
    }
}

