/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.CodeRunner;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.kernel.MarshalExtern;
import org.ocamljava.runtime.kernel.OCamlJavaThread;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Marshal", source="byterun/extern.c")
public final class Extern {
    private Extern() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "'a", "Marshal.extern_flags list"}, returnType="unit")
    public static Value caml_output_value(Value channel, Value v, Value flags) throws Fail.Exception, FalseExit {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        boolean io = false;
        try {
            byte[] b = MarshalExtern.externValue(runner.getContext(), v, flags);
            io = true;
            ((Channel)channel.asCustom()).write(b);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(runner.getContext());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, io ? ioe.toString() : "error during marshalling");
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "Marshal.extern_flags list"}, returnType="string")
    public static Value caml_output_value_to_string(Value v, Value flags) throws Fail.Exception, FalseExit {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        try {
            byte[] b = MarshalExtern.externValue(runner.getContext(), v, flags);
            return Value.createString(b);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(runner.getContext());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, "error during marshalling");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"string", "int", "int", "'a", "Marshal.extern_flags list"}, returnType="int")
    public static Value caml_output_value_to_buffer(Value buff, Value offset, Value len, Value v, Value flags) throws Fail.Exception, FalseExit {
        CodeRunner runner = OCamlJavaThread.getCodeRunner();
        try {
            byte[] b = MarshalExtern.externValue(runner.getContext(), v, flags);
            int ofs = offset.asCastedInt();
            int sz = Math.min(b.length, len.asCastedInt());
            System.arraycopy(b, 0, buff.getBytesForModification(), ofs, sz);
            return Value.createLong(sz);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(runner.getContext());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, "error during marshalling");
            return Value.UNIT;
        }
    }
}

