/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ocamljava.runtime.context.CodeState;
import org.ocamljava.runtime.context.Context;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.Fatal;
import org.ocamljava.runtime.kernel.InvalidByteCodeFileException;
import org.ocamljava.runtime.kernel.MarshalIntern;
import org.ocamljava.runtime.util.EncodingUtils;
import org.ocamljava.runtime.util.IO;
import org.ocamljava.runtime.util.IntegerUtils;
import org.ocamljava.runtime.util.RandomAccessInputStream;
import org.ocamljava.runtime.values.Value;

final class ByteCodeFileLoader {
    private static final String EXEC_MAGIC = "Caml1999X008";
    private static final int TRAILER_SIZE = 16;
    private static final String MD5_ALGO = "MD5";
    private static final String SECTION_SHARED_LIB_PATH = "DLPT";
    private static final String SECTION_SHARED_LIBS = "DLLS";
    private static final String SECTION_REQ_PRIMS = "PRIM";
    private static final String SECTION_CODE = "CODE";
    private static final String SECTION_DATA = "DATA";
    private static final String SECTION_DEBUG = "DBUG";
    private static final int SECTION_NAME_LENGTH = 4;
    private static final int SECTION_SIZE = 8;
    private static final String INVALID_MAGIC = "invalid magic";
    private static final String MISSING_SECTION = "missing '%s' section";
    private static final String INVALID_SECTION = "section of more than 2147483647 bytes";
    private static final String INVALID_CODE_SECTION_SIZE = "code section size should be a multiple of 4";
    private final List<String> primitives;
    private final List<String> sharedLibPath;
    private final List<String> sharedLibs;
    private final int[] code;
    private final Value globalData;
    private final Value debugInfo;

    ByteCodeFileLoader(Context ctxt, RandomAccessInputStream inputStream) throws IOException, InvalidByteCodeFileException, NoSuchAlgorithmException, Fatal.Exception {
        assert (ctxt != null) : "null ctxt";
        assert (inputStream != null) : "null inputStream";
        long length = inputStream.length();
        DataInput in = inputStream.dataInputFrom(length - 16L);
        int nbSections = IntegerUtils.ensure32s(IO.read32u(in));
        byte[] magic = new byte[EXEC_MAGIC.length()];
        in.readFully(magic);
        if (!EXEC_MAGIC.equals(EncodingUtils.convertBytesToString(magic))) {
            throw new InvalidByteCodeFileException(INVALID_MAGIC);
        }
        long offset = 0L;
        in = inputStream.dataInputFrom(length - (long)(16 + 8 * nbSections));
        LinkedHashMap<String, Section> sections = new LinkedHashMap<String, Section>();
        for (int i = 0; i < nbSections; ++i) {
            byte[] tmpName = new byte[4];
            in.readFully(tmpName);
            String name = EncodingUtils.convertBytesToString(tmpName);
            long lenSection = IO.read32u(in);
            if (lenSection > Integer.MAX_VALUE) {
                throw new InvalidByteCodeFileException(INVALID_SECTION);
            }
            sections.put(name, new Section(name, offset, (int)lenSection));
            offset += lenSection;
        }
        for (Section s : sections.values()) {
            s.offset = length - (offset - s.offset + 16L + (long)(8 * nbSections));
        }
        Section codeSection = (Section)sections.get(SECTION_CODE);
        if (codeSection == null) {
            throw new InvalidByteCodeFileException(String.format(MISSING_SECTION, SECTION_CODE));
        }
        int codeSize = codeSection.size;
        if (codeSize % 4 != 0) {
            throw new InvalidByteCodeFileException(INVALID_CODE_SECTION_SIZE);
        }
        byte[] codeData = new byte[codeSize];
        in = inputStream.dataInputFrom(codeSection.offset);
        in.readFully(codeData);
        CodeState codeState = ctxt.getCodeState();
        MessageDigest md5 = MessageDigest.getInstance(MD5_ALGO);
        byte[] codeDigest = md5.digest(codeData);
        codeState.setCodeDigest(codeDigest);
        for (int ptr = 0; ptr < codeSize; ptr += 4) {
            byte tmp = codeData[ptr];
            codeData[ptr] = codeData[ptr + 3];
            codeData[ptr + 3] = tmp;
            tmp = codeData[ptr + 1];
            codeData[ptr + 1] = codeData[ptr + 2];
            codeData[ptr + 2] = tmp;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(codeData);
        DataInputStream dis = new DataInputStream(bais);
        int lenCode = codeSize / 4;
        this.code = new int[lenCode];
        for (int i = 0; i < lenCode; ++i) {
            this.code[i] = dis.readInt();
        }
        codeState.appendCode(this.code);
        codeState.setupCallbackTail();
        this.sharedLibPath = Collections.unmodifiableList(ByteCodeFileLoader.readSection(inputStream, SECTION_SHARED_LIB_PATH, sections, false));
        this.sharedLibs = Collections.unmodifiableList(ByteCodeFileLoader.readSection(inputStream, SECTION_SHARED_LIBS, sections, false));
        List<String> primList = ByteCodeFileLoader.readSection(inputStream, SECTION_REQ_PRIMS, sections, true);
        if (primList == null || primList.size() == 0) {
            throw new InvalidByteCodeFileException(String.format(MISSING_SECTION, SECTION_REQ_PRIMS));
        }
        this.primitives = Collections.unmodifiableList(primList);
        Section data = (Section)sections.get(SECTION_DATA);
        if (data == null) {
            throw new InvalidByteCodeFileException(String.format(MISSING_SECTION, SECTION_DATA));
        }
        in = inputStream.dataInputFrom(data.offset);
        try {
            this.globalData = MarshalIntern.inputVal(ctxt, in, true);
        }
        catch (Fail.Exception fe) {
            throw new InvalidByteCodeFileException(fe.getMessage());
        }
        codeState.setGlobalData(this.globalData);
        Section debug = (Section)sections.get(SECTION_DEBUG);
        if (debug != null) {
            in = inputStream.dataInputFrom(debug.offset);
            int numEvents = IntegerUtils.ensure32s(IO.read32u(in));
            Value events = Value.createBlock(0, numEvents);
            for (int i = 0; i < numEvents; ++i) {
                Value evl;
                int orig = IntegerUtils.ensure32s(IO.read32u(in));
                try {
                    evl = MarshalIntern.inputVal(ctxt, in, true);
                }
                catch (Fail.Exception fe) {
                    throw new InvalidByteCodeFileException(fe.toString());
                }
                for (Value l = evl; l != Value.EMPTY_LIST; l = l.get1()) {
                    Value blk = l.get0();
                    blk.set(0L, Value.createLong(blk.get(0L).asLong() + (long)orig));
                }
                events.set(i, evl);
            }
            this.debugInfo = events;
        } else {
            this.debugInfo = Value.FALSE;
        }
        codeState.setDebugInfo(this.debugInfo);
    }

    List<String> getSharedLibPath() {
        return this.sharedLibPath;
    }

    List<String> getSharedLibs() {
        return this.sharedLibs;
    }

    List<String> getPrimitives() {
        return this.primitives;
    }

    int[] getCode() {
        return this.code;
    }

    Value getGlobalData() {
        return this.globalData;
    }

    Value getDebugInfo() {
        return this.debugInfo;
    }

    private static List<String> readSection(RandomAccessInputStream in, String name, Map<String, Section> sections, boolean mandatory) throws IOException {
        assert (in != null) : "null in";
        assert (name != null) : "null name";
        assert (sections != null) : "null sections";
        LinkedList<String> res = new LinkedList<String>();
        Section section = sections.get(name);
        if (section != null) {
            int len = section.size;
            byte[] data = new byte[len];
            in.dataInputFrom(section.offset).readFully(data);
            for (int idx = 0; idx < len && data[idx] != 0; ++idx) {
                int start = idx;
                while (idx < len && data[idx] != 0) {
                    ++idx;
                }
                res.add(EncodingUtils.convertBytesToString(data, start, idx - start));
            }
            return res;
        }
        return mandatory ? null : res;
    }

    private static final class Section {
        private final String name;
        private long offset;
        private final int size;

        private Section(String n, long ofs, int s) {
            assert (n != null) : "null n";
            assert (ofs >= 0L) : "ofs should be >= 0";
            assert (s >= 0) : "s should be >= 0";
            this.name = n;
            this.offset = ofs;
            this.size = s;
        }
    }
}

