/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class ShellUtils {
    private ShellUtils() {
    }

    public static String[] prepareArguments(String[] args) {
        assert (args != null) : "null args";
        int len = args.length;
        String[] res = new String[len];
        for (int i = 0; i < len; ++i) {
            String s = args[i];
            int slen = s.length();
            if (slen >= 2) {
                char first = s.charAt(0);
                int lastIndex = slen - 1;
                res[i] = lastIndex >= 0 && (first == '\'' || first == '\"') && first == s.charAt(lastIndex) ? s.substring(1, lastIndex) : s;
                continue;
            }
            res[i] = s;
        }
        return res;
    }

    public static List<String> parseCommandLine(String s) {
        assert (s != null) : "null s";
        LinkedList<String> res = new LinkedList<String>();
        StringBuilder token = new StringBuilder();
        ParserState state = ParserState.NORMAL;
        int len = s.length();
        block12: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (state) {
                case NORMAL: {
                    switch (ch) {
                        case ' ': {
                            if (token.length() > 0) {
                                res.add(token.toString());
                            }
                            token = new StringBuilder();
                            continue block12;
                        }
                        case '\\': {
                            state = ParserState.ESCAPED;
                            continue block12;
                        }
                        case '\'': {
                            state = ParserState.SINGLE_QUOTE;
                            continue block12;
                        }
                        case '\"': {
                            state = ParserState.DOUBLE_QUOTE;
                            continue block12;
                        }
                    }
                    token.append(ch);
                    continue block12;
                }
                case SINGLE_QUOTE: {
                    if (ch == '\'') {
                        state = ParserState.NORMAL;
                        continue block12;
                    }
                    token.append(ch);
                    continue block12;
                }
                case DOUBLE_QUOTE: {
                    if (ch == '\"') {
                        state = ParserState.NORMAL;
                        continue block12;
                    }
                    token.append(ch);
                    continue block12;
                }
                case ESCAPED: {
                    state = ParserState.NORMAL;
                    token.append(ch);
                    continue block12;
                }
                default: {
                    assert (false) : "invalid state";
                    continue block12;
                }
            }
        }
        if (token.length() > 0) {
            res.add(token.toString());
        }
        return res;
    }

    public static String[] expandCommandLine(File directory, String[] args) throws IOException {
        assert (directory != null) : "null directory";
        assert (directory.exists() && directory.isDirectory()) : "directory should be an existing directory";
        assert (args != null) : "null args";
        LinkedList<String> tmp = new LinkedList<String>();
        for (String a : args) {
            ShellUtils.expandArgument(directory, a, tmp);
        }
        String[] res = new String[tmp.size()];
        return tmp.toArray(res);
    }

    private static void expandArgument(File dir, String arg, List<String> list) throws IOException {
        assert (dir != null) : "null dir";
        assert (dir.exists() && dir.isDirectory()) : "dir should be an existing directory";
        assert (arg != null) : "null arg";
        assert (list != null) : "null list";
        int len = arg.length();
        if (arg.indexOf(42) > -1 || arg.indexOf(63) > -1) {
            ShellUtils.expandPattern(dir, arg, list);
        } else {
            list.add(arg);
        }
    }

    private static void expandPattern(File dir, String patt, List<String> list) throws IOException {
        assert (dir != null) : "null dir";
        assert (dir.exists() && dir.isDirectory()) : "dir should be an existing directory";
        assert (patt != null) : "null patt";
        assert (list != null) : "null list";
        try {
            Pattern p = ShellUtils.compilePattern(patt);
            for (String file : dir.list()) {
                if (!p.matcher(file).matches()) continue;
                list.add(file);
            }
        }
        catch (PatternSyntaxException pse) {
            list.add(patt);
        }
    }

    private static Pattern compilePattern(String s) throws PatternSyntaxException {
        assert (s != null) : "null s";
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        block5: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                case '.': {
                    sb.append("\\.");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return Pattern.compile(sb.toString());
    }

    private static enum ParserState {
        NORMAL,
        SINGLE_QUOTE,
        DOUBLE_QUOTE,
        ESCAPED;

    }
}

