/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import java.util.concurrent.atomic.AtomicIntegerArray;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicInt32Array", source="")
public final class AtomicInt32Array {
    private AtomicInt32Array() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"int32"}, returnType="AtomicInt32Array.t")
    public static Value ocamljava_atomicint32array_make(Value length) throws Fail.Exception {
        try {
            return Value.createInstance(new AtomicIntegerArray(length.asInt32()));
        }
        catch (Throwable t) {
            Fail.failWith("AtomicInt32Array.make");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_add_and_get(Value obj, Value i, Value delta) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            int res = inst.addAndGet(i.asInt32(), delta.asInt32());
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicint32array_compare_and_set(Value obj, Value i, Value expect, Value update) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            boolean res = inst.compareAndSet(i.asInt32(), expect.asInt32(), update.asInt32());
            return res ? Value.TRUE : Value.FALSE;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_decrement_and_get(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            int res = inst.decrementAndGet(i.asInt32());
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            int res = inst.get(i.asInt32());
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get_and_add(Value obj, Value i, Value delta) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            int res = inst.getAndAdd(i.asInt32(), delta.asInt32());
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get_and_decrement(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            int res = inst.getAndDecrement(i.asInt32());
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get_and_increment(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            int res = inst.getAndIncrement(i.asInt32());
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_get_and_set(Value obj, Value i, Value newValue) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            int res = inst.getAndSet(i.asInt32(), newValue.asInt32());
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32"}, returnType="int32")
    public static Value ocamljava_atomicint32array_increment_and_get(Value obj, Value i) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            int res = inst.incrementAndGet(i.asInt32());
            return Value.createInt32(res);
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="unit")
    public static Value ocamljava_atomicint32array_lazy_set(Value obj, Value i, Value newValue) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            inst.lazySet(i.asInt32(), newValue.asInt32());
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t"}, returnType="int32")
    public static Value ocamljava_atomicint32array_length(Value obj) {
        AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
        int res = inst.length();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32"}, returnType="unit")
    public static Value ocamljava_atomicint32array_set(Value obj, Value i, Value newValue) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            inst.set(i.asInt32(), newValue.asInt32());
            return Value.UNIT;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"AtomicInt32Array.t", "int32", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicint32array_weak_compare_and_set(Value obj, Value i, Value expect, Value update) throws Fail.Exception {
        try {
            AtomicIntegerArray inst = (AtomicIntegerArray)obj.asCustom();
            boolean res = inst.weakCompareAndSet(i.asInt32(), expect.asInt32(), update.asInt32());
            return res ? Value.TRUE : Value.FALSE;
        }
        catch (Throwable t) {
            Fail.arrayBoundError();
            return Value.UNIT;
        }
    }
}

