/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class WeakBlockValue
extends BlockValue {
    private WeakReference<Value>[] values;

    WeakBlockValue(int sz) {
        super(251, sz);
        assert (sz >= 0) : "sz should be >= 0";
        this.values = new WeakReference[sz];
        for (int i = 0; i < sz; ++i) {
            this.values[i] = new WeakReference<Object>(null);
        }
    }

    @Override
    public Value getWeak(long i) throws ArrayIndexOutOfBoundsException {
        return (Value)this.values[(int)i].get();
    }

    @Override
    public void setWeak(long i, Value v) throws ArrayIndexOutOfBoundsException {
        this.values[(int)i] = new WeakReference<Value>(v);
    }

    @Override
    public long sizeValues() {
        return this.values.length;
    }

    @Override
    public long sizeWeakValues() {
        return this.values.length;
    }

    @Override
    protected void truncateInstance(long sz) {
        this.values = Arrays.copyOf(this.values, (int)sz);
    }

    @Override
    public void copy(BlockValue src) {
        int len = (int)Math.min((long)this.values.length, src.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            this.values[i] = new WeakReference<Value>(src.getWeak(i));
        }
    }

    @Override
    public WeakBlockValue duplicate() {
        int len = this.values.length;
        WeakBlockValue res = new WeakBlockValue(len);
        for (int i = 0; i < len; ++i) {
            res.values[i] = new WeakReference(this.values[i].get());
        }
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[i] = this.getWeak(i);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getWeak(i);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getWeak(i).asDouble();
        }
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = (int)Math.min(Integer.MAX_VALUE, this.sizeWeakValues());
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = this.getWeak(i).getRawValue();
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        int l = (int)len;
        WeakBlockValue res = new WeakBlockValue(l);
        System.arraycopy(this.values, (int)ofs, res.values, 0, l);
        return res;
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (dest instanceof WeakBlockValue) {
            WeakBlockValue that = (WeakBlockValue)dest;
            System.arraycopy(this.values, (int)srcOfs, that.values, (int)destOfs, (int)len);
        } else if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.setWeak(destOfs + i, this.getWeak(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.setWeak(destOfs + i, this.getWeak(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        int len = Math.min(32, this.values.length);
        for (int i = 0; i < len; ++i) {
            res += this.values[i].hashCode();
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WeakBlockValue) {
            WeakBlockValue that = (WeakBlockValue)obj;
            return Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WeakBlockValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            Value v;
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((v = (Value)this.values[i].get()) == null ? "null" : v.toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

