/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.otherlibs.graph;

import java.awt.image.BufferedImage;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.primitives.otherlibs.graph.CustomImage;
import org.ocamljava.runtime.primitives.otherlibs.graph.GraphSlot;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="graph", module="Graphics", source="otherlibs/graph/make_img.c")
public final class MakeImage {
    private static final int TRANSPARENT = -1;

    private MakeImage() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Graphics.color array array"}, returnType="Graphics.image")
    public static Value caml_gr_make_image(Value m) throws Fail.Exception {
        GraphSlot.checkGraph();
        int height = (int)m.sizeValues();
        if (height == 0) {
            return Value.createCustom(CustomImage.OPS, 16L, new BufferedImage(0, 0, 2));
        }
        int width = (int)m.get0().sizeValues();
        for (int i = 1; i < height; ++i) {
            if (m.get(i).sizeValues() == (long)width) continue;
            GraphSlot.fail("make_image: lines of different lengths", "");
        }
        int[] pixels = new int[height * width];
        for (int i = 0; i < height; ++i) {
            Value line = m.get(i);
            for (int j = 0; j < width; ++j) {
                int rgb = line.get(j).asCastedInt();
                pixels[i * width + j] = rgb == -1 ? 0 : rgb | 0xFF000000;
            }
        }
        BufferedImage img = new BufferedImage(width, height, 2);
        img.setRGB(0, 0, width, height, pixels, 0, width);
        return Value.createCustom(CustomImage.OPS, 16L, img);
    }
}

