/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="AtomicStampedReference", source="")
public final class AtomicStampedReference {
    private AtomicStampedReference() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a", "int32"}, returnType="'a AtomicStampedReference.t")
    public static Value ocamljava_atomicstampedreference_make(Value initialRef, Value initialStamp) {
        return Value.createInstance(new java.util.concurrent.atomic.AtomicStampedReference<Value>(initialRef, initialStamp.asInt32()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicStampedReference.t", "'a", "int32"}, returnType="bool")
    public static Value ocamljava_atomicstampedreference_attempt_stamp(Value obj, Value expectedReference, Value newStamp) {
        java.util.concurrent.atomic.AtomicStampedReference inst = (java.util.concurrent.atomic.AtomicStampedReference)obj.asCustom();
        boolean res = inst.attemptStamp(expectedReference, newStamp.asInt32());
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicStampedReference.t", "'a", "'a", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicstampedreference_compare_and_set(Value obj, Value expectedReference, Value newReference, Value expectedStamp, Value newStamp) {
        java.util.concurrent.atomic.AtomicStampedReference inst = (java.util.concurrent.atomic.AtomicStampedReference)obj.asCustom();
        boolean res = inst.compareAndSet(expectedReference, newReference, expectedStamp.asInt32(), newStamp.asInt32());
        return res ? Value.TRUE : Value.FALSE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicStampedReference.t"}, returnType="'a * int32")
    public static Value ocamljava_atomicstampedreference_get(Value obj) {
        java.util.concurrent.atomic.AtomicStampedReference inst = (java.util.concurrent.atomic.AtomicStampedReference)obj.asCustom();
        int[] stampHolder = new int[1];
        Value res = (Value)inst.get(stampHolder);
        return Value.createBlock(0, res, Value.createInt32(stampHolder[0]));
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicStampedReference.t"}, returnType="'a")
    public static Value ocamljava_atomicstampedreference_get_reference(Value obj) {
        java.util.concurrent.atomic.AtomicStampedReference inst = (java.util.concurrent.atomic.AtomicStampedReference)obj.asCustom();
        Value res = (Value)inst.getReference();
        return res;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicStampedReference.t"}, returnType="int32")
    public static Value ocamljava_atomicstampedreference_get_stamp(Value obj) {
        java.util.concurrent.atomic.AtomicStampedReference inst = (java.util.concurrent.atomic.AtomicStampedReference)obj.asCustom();
        int res = inst.getStamp();
        return Value.createInt32(res);
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicStampedReference.t", "'a", "int32"}, returnType="unit")
    public static Value ocamljava_atomicstampedreference_set(Value obj, Value newReference, Value newStamp) {
        java.util.concurrent.atomic.AtomicStampedReference inst = (java.util.concurrent.atomic.AtomicStampedReference)obj.asCustom();
        inst.set(newReference, newStamp.asInt32());
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"'a AtomicStampedReference.t", "'a", "'a", "int32", "int32"}, returnType="bool")
    public static Value ocamljava_atomicstampedreference_weak_compare_and_set(Value obj, Value expectedReference, Value newReference, Value expectedStamp, Value newStamp) {
        java.util.concurrent.atomic.AtomicStampedReference inst = (java.util.concurrent.atomic.AtomicStampedReference)obj.asCustom();
        boolean res = inst.weakCompareAndSet(expectedReference, newReference, expectedStamp.asInt32(), newStamp.asInt32());
        return res ? Value.TRUE : Value.FALSE;
    }
}

