/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.annotations.primitives;

import java.io.IOException;
import java.io.PrintStream;
import org.ocamljava.runtime.annotations.primitives.AbstractPrimitivesConverter;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;

public final class Primitives2Service
extends AbstractPrimitivesConverter {
    private final PrintStream out;

    private Primitives2Service(String b, String p, String f) throws IOException {
        super(b, p);
        assert (f != null) : "null f";
        this.out = new PrintStream(f);
    }

    @Override
    protected void beforeWalk() {
        this.out.printf("<service type=\"%s\">\n", PrimitiveProvider.class.getName());
    }

    @Override
    protected void visitClass(String className) {
        try {
            Class<?> cl = Class.forName(className);
            if (cl.getAnnotation(PrimitiveProvider.class) != null) {
                this.out.printf("  <provider classname=\"%s\"/>\n", className);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void afterWalk() {
        this.out.println("</service>");
        this.out.close();
    }

    public static void main(String[] args) {
        PrintStream err = System.err;
        if (args.length == 3) {
            try {
                Primitives2Service p2s = new Primitives2Service(args[0], args[1], args[2]);
                p2s.walkFileTree();
            }
            catch (IOException ioe) {
                err.printf("i/o error: %s\n", ioe.getMessage());
                System.exit(1);
            }
            System.exit(0);
        } else {
            err.println("error: a path, a pattern, and a file should be provided");
            System.exit(1);
        }
    }
}

