/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.support.scripting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.ocamljava.runtime.values.Value;

public final class OCamlBindings
implements Bindings {
    private final Map<String, Object> values = new HashMap<String, Object>();

    @Override
    public boolean containsKey(Object key) {
        assert (key != null) : "null key";
        if (((String)key).length() == 0) {
            throw new IllegalArgumentException("invalid key");
        }
        return this.values.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        assert (key != null) : "null key";
        if (((String)key).length() == 0) {
            throw new IllegalArgumentException("invalid key");
        }
        return this.values.get(key);
    }

    Value getValue(Object key) throws NullPointerException, ClassCastException, IllegalArgumentException {
        assert (key != null) : "null key";
        if (this.containsKey(key)) {
            return OCamlBindings.convert(this.get(key));
        }
        return Value.createInstance(null);
    }

    @Override
    public Object put(String name, Object value) {
        assert (name != null) : "null name";
        if (name.length() == 0) {
            throw new IllegalArgumentException("invalid key");
        }
        return this.values.put(name, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        assert (toMerge != null) : "null toMerge";
        for (Map.Entry<String, Object> e : this.values.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        assert (key != null) : "null key";
        if (((String)key).length() == 0) {
            throw new IllegalArgumentException("invalid key");
        }
        return this.values.remove(key);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Collection<Object> values() {
        return this.values.values();
    }

    static OCamlBindings instance(Bindings b) {
        assert (b != null) : "null b";
        if (b instanceof OCamlBindings) {
            return (OCamlBindings)b;
        }
        OCamlBindings res = new OCamlBindings();
        res.putAll(b);
        return res;
    }

    static Value convert(Object v) {
        if (v == null) {
            return Value.createInstance(null);
        }
        Class<?> c = v.getClass();
        if (Value.class.equals(c)) {
            return (Value)v;
        }
        if (Boolean.class.equals(c)) {
            return (Boolean)v != false ? Value.TRUE : Value.FALSE;
        }
        if (Byte.class.equals(c)) {
            return Value.createLong(((Byte)v).byteValue());
        }
        if (Character.class.equals(c)) {
            return Value.createLong(((Character)v).charValue());
        }
        if (Double.class.equals(c)) {
            return Value.createDouble((Double)v);
        }
        if (Float.class.equals(c)) {
            return Value.createDouble(((Float)v).floatValue());
        }
        if (Integer.class.equals(c)) {
            return Value.createInt32((Integer)v);
        }
        if (Long.class.equals(c)) {
            return Value.createInt64((Long)v);
        }
        if (Short.class.equals(c)) {
            return Value.createLong(((Short)v).shortValue());
        }
        if (String.class.equals(c)) {
            return Value.createString((String)v);
        }
        return Value.createInstance(v);
    }
}

