/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedChannelException;
import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.kernel.Channel;
import org.ocamljava.runtime.kernel.Fail;
import org.ocamljava.runtime.kernel.FalseExit;
import org.ocamljava.runtime.primitives.stdlib.Sys;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="stdlib", module="Pervasives", source="byterun/io.c")
public final class Io {
    private Io() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="Pervasives.in_channel")
    public static Value caml_ml_open_descriptor_in(Value fd) {
        return Value.createChannel(CurrentContext.getFilesState().getChannel(fd.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="Pervasives.out_channel")
    public static Value caml_ml_open_descriptor_out(Value fd) {
        return Value.createChannel(CurrentContext.getFilesState().getChannel(fd.asCastedInt()));
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"unit"}, returnType="Pervasives.out_channel list")
    public static Value caml_ml_out_channels_list(Value unit) {
        return CurrentContext.getFilesState().makeOutChannelsList();
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="Unix.file_descr")
    public static Value caml_channel_descriptor(Value channel) throws Fail.Exception {
        int res = ((Channel)channel.asCustom()).getFD();
        if (res != -1) {
            return Value.createLong(res);
        }
        Sys.sysError(null, "invalid file descriptor");
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="unit")
    public static Value caml_ml_close_channel(Value channel) throws Fail.Exception, FalseExit {
        try {
            int fd = ((Channel)channel.asCustom()).getFD();
            if (fd != -1) {
                CurrentContext.getFilesState().closeChannel(fd);
            }
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="int")
    public static Value caml_ml_channel_size(Value channel) throws Fail.Exception, FalseExit {
        try {
            long l = ((Channel)channel.asCustom()).size();
            if (l > 0x3FFFFFFFFFFFFFFFL) {
                Sys.sysError(null, "overflow");
            }
            return Value.createLong(l);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, "unable to determine channel size");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a"}, returnType="int64")
    public static Value caml_ml_channel_size_64(Value channel) throws Fail.Exception, FalseExit {
        try {
            return Value.createInt64(((Channel)channel.asCustom()).size());
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, "unable to determine channel size");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Does nothing."}, parameterTypes={"'a", "bool"}, returnType="unit")
    public static Value caml_ml_set_binary_mode(Value channel, Value mode) {
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Exact synonym of [caml_ml_flush]."}, parameterTypes={"Pervasives.out_channel"}, returnType="unit")
    public static Value caml_ml_flush_partial(Value channel) throws Fail.Exception, FalseExit {
        Io.caml_ml_flush(channel);
        return Value.TRUE;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel"}, returnType="unit")
    public static Value caml_ml_flush(Value channel) throws Fail.Exception, FalseExit {
        try {
            CurrentContext.enterBlockingSection();
            ((Channel)channel.asCustom()).flush();
            CurrentContext.leaveBlockingSection();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "char"}, returnType="unit")
    public static Value caml_ml_output_char(Value channel, Value ch) throws Fail.Exception, FalseExit {
        try {
            CurrentContext.enterBlockingSection();
            ((Channel)channel.asCustom()).write8u(ch.asCastedInt());
            CurrentContext.leaveBlockingSection();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "int"}, returnType="unit")
    public static Value caml_ml_output_int(Value channel, Value v) throws Fail.Exception, FalseExit {
        try {
            CurrentContext.enterBlockingSection();
            ((Channel)channel.asCustom()).write32s(v.asCastedInt());
            CurrentContext.leaveBlockingSection();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, comment={"Exact synonym of [caml_ml_output]."}, parameterTypes={"Pervasives.out_channel", "string", "int", "int"}, returnType="unit")
    public static Value caml_ml_output_partial(Value channel, Value buff, Value start, Value length) throws Fail.Exception, FalseExit {
        Io.caml_ml_output(channel, buff, start, length);
        return length;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "string", "int", "int"}, returnType="unit")
    public static Value caml_ml_output(Value channel, Value buff, Value start, Value len) throws Fail.Exception, FalseExit {
        try {
            CurrentContext.enterBlockingSection();
            if (buff.sizeBytes() <= Integer.MAX_VALUE) {
                ((Channel)channel.asCustom()).write(buff.getBytes(), start.asCastedInt(), len.asCastedInt());
            } else {
                int l = len.asCastedInt();
                byte[] tmp = new byte[l];
                long idx = start.asLong();
                for (int i = 0; i < l; ++i) {
                    tmp[i] = buff.getByte(idx + (long)i);
                }
                ((Channel)channel.asCustom()).write(tmp, 0, l);
            }
            CurrentContext.leaveBlockingSection();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "int"}, returnType="unit")
    public static Value caml_ml_seek_out(Value channel, Value pos) throws Fail.Exception, FalseExit {
        try {
            ((Channel)channel.asCustom()).seek(pos.asLong(), 0);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel", "int64"}, returnType="unit")
    public static Value caml_ml_seek_out_64(Value channel, Value pos) throws Fail.Exception, FalseExit {
        try {
            ((Channel)channel.asCustom()).seek(pos.asInt64(), 0);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel"}, returnType="int")
    public static Value caml_ml_pos_out(Value channel) throws Fail.Exception, FalseExit {
        try {
            long pos = ((Channel)channel.asCustom()).position();
            if (pos > 0x3FFFFFFFFFFFFFFFL) {
                Sys.sysError(null, "overflow");
            }
            return Value.createLong(pos);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, "unable to determine channel position");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.out_channel"}, returnType="int64")
    public static Value caml_ml_pos_out_64(Value channel) throws Fail.Exception, FalseExit {
        try {
            return Value.createInt64(((Channel)channel.asCustom()).position());
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, "unable to determine channel position");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="char")
    public static Value caml_ml_input_char(Value channel) throws Fail.Exception, FalseExit {
        try {
            CurrentContext.enterBlockingSection();
            int res = ((Channel)channel.asCustom()).read8u();
            CurrentContext.leaveBlockingSection();
            return Value.createLong(res);
        }
        catch (ClosedChannelException cce) {
            CurrentContext.leaveBlockingSection();
            Fail.raiseEndOfFile();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.int_channel"}, returnType="int")
    public static Value caml_ml_input_int(Value channel) throws Fail.Exception, FalseExit {
        try {
            CurrentContext.enterBlockingSection();
            int res = ((Channel)channel.asCustom()).read32s();
            CurrentContext.leaveBlockingSection();
            return Value.createLong(res);
        }
        catch (ClosedChannelException cce) {
            CurrentContext.leaveBlockingSection();
            Fail.raiseEndOfFile();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel", "string", "int", "int"}, returnType="int")
    public static Value caml_ml_input(Value channel, Value buff, Value start, Value len) throws Fail.Exception, FalseExit {
        try {
            CurrentContext.enterBlockingSection();
            if (buff.sizeBytes() <= Integer.MAX_VALUE) {
                int res = ((Channel)channel.asCustom()).read(buff.getBytesForModification(), start.asCastedInt(), len.asCastedInt());
                CurrentContext.leaveBlockingSection();
                return Value.createLong(Math.max(res, 0));
            }
            int l = len.asCastedInt();
            byte[] tmp = new byte[l];
            int res = ((Channel)channel.asCustom()).read(tmp, 0, l);
            long idx = start.asLong();
            for (int i = 0; i < l; ++i) {
                buff.setByte(idx + (long)i, tmp[i]);
            }
            CurrentContext.leaveBlockingSection();
            return Value.createLong(Math.max(res, 0));
        }
        catch (ClosedChannelException cce) {
            CurrentContext.leaveBlockingSection();
            Fail.raiseEndOfFile();
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel", "int"}, returnType="unit")
    public static Value caml_ml_seek_in(Value channel, Value pos) throws Fail.Exception, FalseExit {
        try {
            ((Channel)channel.asCustom()).seek(pos.asLong(), 0);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel", "int64"}, returnType="unit")
    public static Value caml_ml_seek_in_64(Value channel, Value pos) throws Fail.Exception, FalseExit {
        try {
            ((Channel)channel.asCustom()).seek(pos.asInt64(), 0);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, ioe.toString());
        }
        return Value.UNIT;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="int")
    public static Value caml_ml_pos_in(Value channel) throws Fail.Exception, FalseExit {
        try {
            long pos = ((Channel)channel.asCustom()).position();
            if (pos > 0x3FFFFFFFFFFFFFFFL) {
                Sys.sysError(null, "overflow");
            }
            return Value.createLong(pos);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, "unable to determine channel position");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="int64")
    public static Value caml_ml_pos_in_64(Value channel) throws Fail.Exception, FalseExit {
        try {
            return Value.createInt64(((Channel)channel.asCustom()).position());
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            Sys.sysError(null, "unable to determine channel position");
            return Value.UNIT;
        }
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"Pervasives.in_channel"}, returnType="int")
    public static Value caml_ml_input_scan_line(Value channel) throws Fail.Exception, FalseExit {
        Channel ch = (Channel)channel.asCustom();
        try {
            CurrentContext.enterBlockingSection();
            int res = ch.inputScanline();
            CurrentContext.leaveBlockingSection();
            return Value.createLong(res);
        }
        catch (InterruptedIOException iioe) {
            FalseExit fe = FalseExit.createFromContext(CurrentContext.get());
            fe.fillInStackTrace();
            throw fe;
        }
        catch (IOException ioe) {
            CurrentContext.leaveBlockingSection();
            Sys.sysError(null, ioe.toString());
            return Value.UNIT;
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            Sys.sysError(null, "XXX");
            return Value.UNIT;
        }
    }
}

