/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import org.ocamljava.runtime.values.AbstractBasicBlockValue;
import org.ocamljava.runtime.values.BasicBlockValue0;
import org.ocamljava.runtime.values.BasicBlockValue1;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

public final class BasicBlockValue2
extends AbstractBasicBlockValue {
    private int size;
    private Value v0;
    private Value v1;

    BasicBlockValue2(int tag, Value v0, Value v1) {
        super(tag, 2L);
        assert (v0 != null) : "null v0";
        assert (v1 != null) : "null v1";
        this.size = 2;
        this.v0 = v0;
        this.v1 = v1;
    }

    @Override
    public Value get(long idx) throws ArrayIndexOutOfBoundsException {
        switch ((int)idx) {
            case 0: {
                return this.v0;
            }
            case 1: {
                return this.v1;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public Value get(int idx) throws ArrayIndexOutOfBoundsException {
        switch (idx) {
            case 0: {
                return this.v0;
            }
            case 1: {
                return this.v1;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public Value get0() {
        return this.v0;
    }

    @Override
    public Value get1() {
        return this.v1;
    }

    @Override
    public Value get2() throws ArrayIndexOutOfBoundsException {
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public Value get3() throws ArrayIndexOutOfBoundsException {
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public Value get4() throws ArrayIndexOutOfBoundsException {
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public Value get5() throws ArrayIndexOutOfBoundsException {
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public Value get6() throws ArrayIndexOutOfBoundsException {
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public Value get7() throws ArrayIndexOutOfBoundsException {
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void set(long idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        switch ((int)idx) {
            case 0: {
                this.v0 = x;
                break;
            }
            case 1: {
                this.v1 = x;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @Override
    public void set(int idx, Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        switch (idx) {
            case 0: {
                this.v0 = x;
                break;
            }
            case 1: {
                this.v1 = x;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @Override
    public void set0(Value x) {
        assert (x != null) : "null x";
        this.v0 = x;
    }

    @Override
    public void set1(Value x) {
        assert (x != null) : "null x";
        this.v1 = x;
    }

    @Override
    public void set2(Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void set3(Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void set4(Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void set5(Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void set6(Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public void set7(Value x) throws ArrayIndexOutOfBoundsException {
        assert (x != null) : "null x";
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public long sizeValues() {
        return this.size;
    }

    @Override
    public long arrayLength() {
        return this.size;
    }

    @Override
    public long arrayLengthTagged() {
        switch (this.size) {
            case 0: {
                return 1L;
            }
            case 1: {
                return 3L;
            }
            case 2: {
                return 5L;
            }
        }
        assert (false) : "should not happen";
        return (long)(this.size << 1) | 1L;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        switch (this.size) {
            case 0: {
                return -1L;
            }
            case 1: {
                return 1L;
            }
            case 2: {
                return 3L;
            }
        }
        assert (false) : "should not happen";
        return (long)(this.size << 1) | 1L;
    }

    @Override
    public Value arrayLengthWrapped() {
        switch (this.size) {
            case 0: {
                return Value.ZERO;
            }
            case 1: {
                return Value.ONE;
            }
            case 2: {
                return Value.TWO;
            }
        }
        assert (false) : "should not happen";
        return Value.createLong(this.size);
    }

    @Override
    protected void truncateInstance(long sz) {
        int s;
        this.size = s = (int)sz;
        for (int i = s; i < 2; ++i) {
            this.set(i, Value.ZERO);
        }
    }

    @Override
    public void copy(BlockValue src) {
        int sz = (int)Math.min((long)this.size, src.sizeValues());
        for (int i = 0; i < sz; ++i) {
            this.set(i, src.get(i));
        }
    }

    @Override
    public BasicBlockValue2 duplicate() {
        return new BasicBlockValue2(this.getTag(), this.v0, this.v1);
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        dest[0] = this.v0;
        dest[1] = this.v1;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        dest[destOfs + 0] = this.v0;
        dest[destOfs + 1] = this.v1;
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        dest[destOfs + 0] = this.v0.asDouble();
        dest[destOfs + 1] = this.v1.asDouble();
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        dest[destOfs + 0] = this.v0.getRawValue();
        dest[destOfs + 1] = this.v1.getRawValue();
    }

    @Override
    public Value subArray(long ofs, long len) {
        int tag = this.getTag();
        switch ((int)len) {
            case 0: {
                return new BasicBlockValue0(tag);
            }
            case 1: {
                switch ((int)ofs) {
                    case 0: {
                        return new BasicBlockValue1(tag, this.v0);
                    }
                }
                return new BasicBlockValue1(tag, this.v1);
            }
        }
        return new BasicBlockValue2(tag, this.v0, this.v1);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.set(destOfs + i, this.get(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        return (int)this.header + this.v0.hashCode() + this.v1.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicBlockValue2) {
            BasicBlockValue2 that = (BasicBlockValue2)obj;
            return this.header == that.header && this.v0.equals(that.v0) && this.v1.equals(that.v1);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BasicBlockValue2(");
        sb.append(this.v0);
        sb.append(", ");
        sb.append(this.v1);
        sb.append(")");
        return sb.toString();
    }
}

