/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.io.ByteArrayInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public final class Beep
extends AudioInputStream {
    private static final int SAMPLE_SIZE_IN_BITS = 16;
    private static final int CHANNELS = 2;
    private static final int FRAME_SIZE = 4;
    private static final boolean LITTLE_ENDIAN = false;
    private static final float VOLUME = 0.7f;
    private static final int BYTE_MASK = 255;
    private static final int BITS_PER_BYTE = 8;
    private static final long MILLISECS_PER_SEC = 1000L;
    private static final double TWO_PI = Math.PI * 2;

    public Beep(float sampleRate, float frequency, long duration) {
        super(new ByteArrayInputStream(Beep.createData(sampleRate, frequency, duration)), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, 16, 2, 4, sampleRate, false), -1L);
        assert (sampleRate > 0.0f) : "sampleRate should be > 0.0f";
        assert (frequency > 0.0f) : "frequency should be > 0.0f";
        assert (duration > 0L) : "duration should be > 0";
    }

    private static byte[] createData(float sampleRate, float frequency, long duration) {
        assert (sampleRate > 0.0f) : "sampleRate should be > 0.0f";
        assert (frequency > 0.0f) : "frequency should be > 0.0f";
        assert (duration > 0L) : "duration should be > 0";
        float amplitude = 0.7f * (float)Math.pow(2.0, 15.0);
        int periodLengthInFrames = Math.round(sampleRate / frequency);
        int len = Math.round(sampleRate * (float)duration / 1000.0f);
        int bufferLength = len * 4;
        byte[] res = new byte[bufferLength];
        for (int frame = 0; frame < len; ++frame) {
            float periodPosition = (float)(frame % periodLengthInFrames) / (float)periodLengthInFrames;
            float value = (float)Math.sin((double)periodPosition * (Math.PI * 2));
            int val = Math.round(value * amplitude);
            int ofs = frame * 4;
            byte low = (byte)(val & 0xFF);
            byte high = (byte)(val >>> 8 & 0xFF);
            res[ofs + 0] = low;
            res[ofs + 1] = high;
            res[ofs + 2] = low;
            res[ofs + 3] = high;
        }
        return res;
    }
}

