/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.stdlib;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.context.CurrentContext;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="[runtime]", module="[runtime]", source="byterun/alloc.c")
public final class Alloc {
    private Alloc() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="'a")
    public static Value caml_alloc_dummy(Value size) {
        long sz = size.asLong();
        if (sz == 0L) {
            return CurrentContext.getCodeState().getAtom(0);
        }
        return Value.createBlock(0, sz);
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"int"}, returnType="'a")
    public static Value caml_alloc_dummy_float(Value size) {
        long sz = size.asLong();
        if (sz == 0L) {
            return CurrentContext.getCodeState().getAtom(0);
        }
        Value res = Value.createDoubleArray(sz);
        res.setTag(0);
        return res;
    }

    @Primitive(compatibility=PrimitiveCompatibility.FULL, parameterTypes={"'a", "'a"}, returnType="unit")
    public static Value caml_update_dummy(Value dummy, Value newval) {
        BlockValue dummyBlock = dummy.asBlock();
        BlockValue newvalBlock = newval.asBlock();
        long sz = ((Value)newvalBlock).getWoSize();
        int tag = ((Value)newvalBlock).getTag();
        assert (sz == ((Value)dummyBlock).getWoSize()) : "sizes should be equal";
        assert (tag < 251 || tag == 254) : "invalid tag";
        ((Value)dummyBlock).setTag(tag);
        ((Value)dummyBlock).asBlock().copy(((Value)newvalBlock).asBlock());
        return Value.UNIT;
    }
}

