/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.primitives.javalibs.concurrent;

import org.ocamljava.runtime.annotations.primitives.Primitive;
import org.ocamljava.runtime.annotations.primitives.PrimitiveCompatibility;
import org.ocamljava.runtime.annotations.primitives.PrimitiveProvider;
import org.ocamljava.runtime.values.Value;

@PrimitiveProvider(library="concurrent", module="TimeUnit", source="")
public final class TimeUnit {
    private TimeUnit() {
    }

    @Primitive(compatibility=PrimitiveCompatibility.ORIGINAL, parameterTypes={"TimeUnit.t", "TimeUnit.t", "int64"}, returnType="int64")
    public static Value ocamljava_timeunit_convert(Value from, Value to, Value duration) {
        java.util.concurrent.TimeUnit f = TimeUnit.decode(from);
        java.util.concurrent.TimeUnit t = TimeUnit.decode(to);
        long d = duration.asInt64();
        long res = t.convert(d, f);
        return Value.createInt64(res);
    }

    static java.util.concurrent.TimeUnit decode(Value x) {
        switch ((int)x.asLong()) {
            case 0: {
                return java.util.concurrent.TimeUnit.NANOSECONDS;
            }
            case 1: {
                return java.util.concurrent.TimeUnit.MICROSECONDS;
            }
            case 2: {
                return java.util.concurrent.TimeUnit.MILLISECONDS;
            }
            case 3: {
                return java.util.concurrent.TimeUnit.SECONDS;
            }
            case 4: {
                return java.util.concurrent.TimeUnit.MINUTES;
            }
            case 5: {
                return java.util.concurrent.TimeUnit.HOURS;
            }
            case 6: {
                return java.util.concurrent.TimeUnit.DAYS;
            }
        }
        assert (false) : "should not happen";
        return null;
    }
}

