/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.kernel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ocamljava.runtime.kernel.CodeRunner;

public final class OCamlJavaThread
extends Thread {
    private static final String INTERP_THREAD_GROUP_PREFIX = "OCaml-Java-Bytecode-";
    private static final String NATIVE_THREAD_GROUP_PREFIX = "OCaml-Java-Native-";
    private static final AtomicInteger NEXT_GROUP_ID = new AtomicInteger();
    private static final String THREAD_PREFIX = "OCaml-Java-Thread-";
    private static final AtomicInteger NEXT_THREAD_ID = new AtomicInteger();
    private static final Map<Thread, CodeRunner> RUNNERS = Collections.synchronizedMap(new HashMap());
    private static final ThreadLocal<CodeRunner> CURRENT_RUNNER = new ThreadLocal<CodeRunner>(){

        @Override
        protected CodeRunner initialValue() {
            CodeRunner res = (CodeRunner)RUNNERS.get(Thread.currentThread());
            if (res != null) {
                return res;
            }
            if (RUNNERS.size() == 1) {
                return (CodeRunner)RUNNERS.values().iterator().next();
            }
            return null;
        }
    };
    private final CodeRunner runner;
    private boolean paused;

    public OCamlJavaThread(ThreadGroup group, CodeRunner run) {
        super(group, run, OCamlJavaThread.getNextName());
        assert (group != null) : "null group";
        assert (run != null) : "null run";
        this.runner = run;
        this.paused = false;
        RUNNERS.put(this, run);
    }

    public OCamlJavaThread(ThreadGroup group, String name, CodeRunner run) {
        super(group, run, name);
        assert (run != null) : "null run";
        assert (name != null) : "null name";
        this.runner = run;
        this.paused = false;
        RUNNERS.put(this, run);
    }

    public static void registerCodeRunner(Thread t, CodeRunner runner) {
        assert (t != null) : "null t";
        assert (runner != null) : "null runner";
        RUNNERS.put(t, runner);
    }

    public static boolean isRegistered(Thread t) {
        assert (t != null) : "null t";
        return RUNNERS.get(t) != null;
    }

    public static CodeRunner getCodeRunner() {
        return CURRENT_RUNNER.get();
    }

    public CodeRunner getRunner() {
        return this.runner;
    }

    public void pause() {
        this.paused = true;
        super.suspend();
    }

    public void wakeUp() {
        this.paused = false;
        super.resume();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void asksToStop() {
        try {
            super.stop();
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
    }

    public static String getNextThreadGroupName(boolean isNative) {
        StringBuilder sb = new StringBuilder(isNative ? NATIVE_THREAD_GROUP_PREFIX : INTERP_THREAD_GROUP_PREFIX);
        sb.append(NEXT_GROUP_ID.getAndIncrement());
        return sb.toString();
    }

    private static String getNextName() {
        StringBuilder sb = new StringBuilder(THREAD_PREFIX);
        sb.append(NEXT_THREAD_ID.getAndIncrement());
        return sb.toString();
    }
}

