/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.util.Arrays;
import org.ocamljava.runtime.values.AbstractDoubleArrayValue;
import org.ocamljava.runtime.values.BlockValue;
import org.ocamljava.runtime.values.DoubleArrayValue0;
import org.ocamljava.runtime.values.DoubleArrayValue1;
import org.ocamljava.runtime.values.DoubleArrayValue2;
import org.ocamljava.runtime.values.DoubleArrayValue3;
import org.ocamljava.runtime.values.DoubleArrayValue4;
import org.ocamljava.runtime.values.DoubleArrayValue5;
import org.ocamljava.runtime.values.DoubleArrayValue6;
import org.ocamljava.runtime.values.DoubleArrayValue7;
import org.ocamljava.runtime.values.DoubleArrayValue8;
import org.ocamljava.runtime.values.Value;

public final class DoubleArrayValue
extends AbstractDoubleArrayValue {
    private int sizeTagged;
    private int sizeMinusOneTagged;
    private Value sizeWrapped;
    private double[] values;

    DoubleArrayValue(int sz) {
        super(254, (long)sz * 1L);
        this.values = new double[sz];
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
    }

    DoubleArrayValue(double[] vals) {
        super(254, (long)vals.length * 1L);
        int sz = vals.length;
        this.values = vals;
        this.sizeTagged = sz << 1 | 1;
        this.sizeMinusOneTagged = sz - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(sz);
    }

    @Override
    public double getDouble(long idx) throws ArrayIndexOutOfBoundsException {
        return this.values[(int)idx];
    }

    @Override
    public double getDouble(int idx) throws ArrayIndexOutOfBoundsException {
        return this.values[idx];
    }

    @Override
    public double getDouble0() {
        return this.values[0];
    }

    @Override
    public double getDouble1() {
        return this.values[1];
    }

    @Override
    public double getDouble2() {
        return this.values[2];
    }

    @Override
    public double getDouble3() {
        return this.values[3];
    }

    @Override
    public double getDouble4() {
        return this.values[4];
    }

    @Override
    public double getDouble5() {
        return this.values[5];
    }

    @Override
    public double getDouble6() {
        return this.values[6];
    }

    @Override
    public double getDouble7() {
        return this.values[7];
    }

    @Override
    public void setDouble(long idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[(int)idx] = x;
    }

    @Override
    public void setDouble(int idx, double x) throws ArrayIndexOutOfBoundsException {
        this.values[idx] = x;
    }

    @Override
    public void setDouble0(double x) {
        this.values[0] = x;
    }

    @Override
    public void setDouble1(double x) {
        this.values[1] = x;
    }

    @Override
    public void setDouble2(double x) {
        this.values[2] = x;
    }

    @Override
    public void setDouble3(double x) {
        this.values[3] = x;
    }

    @Override
    public void setDouble4(double x) {
        this.values[4] = x;
    }

    @Override
    public void setDouble5(double x) {
        this.values[5] = x;
    }

    @Override
    public void setDouble6(double x) {
        this.values[6] = x;
    }

    @Override
    public void setDouble7(double x) {
        this.values[7] = x;
    }

    @Override
    public long sizeDoubles() {
        return this.values.length;
    }

    @Override
    public long arrayLength() {
        return this.values.length;
    }

    @Override
    public long arrayLengthTagged() {
        return this.sizeTagged;
    }

    @Override
    public long arrayLengthMinusOneTagged() {
        return this.sizeMinusOneTagged;
    }

    @Override
    public Value arrayLengthWrapped() {
        return this.sizeWrapped;
    }

    @Override
    protected void truncateInstance(long sz) {
        int s = (int)(sz / 1L);
        this.values = Arrays.copyOf(this.values, s);
        this.sizeTagged = s << 1 | 1;
        this.sizeMinusOneTagged = s - 1 << 1 | 1;
        this.sizeWrapped = Value.createLong(s);
    }

    @Override
    public void copy(BlockValue src) {
        int len = (int)Math.min((long)this.values.length, src.sizeDoubles());
        for (int i = 0; i < len; ++i) {
            this.values[i] = src.getDouble(i);
        }
    }

    @Override
    public DoubleArrayValue duplicate() {
        int len = this.values.length;
        DoubleArrayValue res = new DoubleArrayValue(len);
        System.arraycopy(this.values, 0, res.values, 0, len);
        return res;
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[i] = Value.createDouble(this.values[i]);
        }
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = Value.createDouble(this.values[i]);
        }
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
        System.arraycopy(this.values, 0, dest, destOfs, this.values.length);
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            dest[destOfs + i] = (long)this.values[i];
        }
    }

    @Override
    public Value subArray(long ofs, long len) {
        int l = (int)len;
        int o = (int)ofs;
        switch (l) {
            case 0: {
                return new DoubleArrayValue0();
            }
            case 1: {
                return new DoubleArrayValue1(this.values[o + 0]);
            }
            case 2: {
                return new DoubleArrayValue2(this.values[o + 0], this.values[o + 1]);
            }
            case 3: {
                return new DoubleArrayValue3(this.values[o + 0], this.values[o + 1], this.values[o + 2]);
            }
            case 4: {
                return new DoubleArrayValue4(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3]);
            }
            case 5: {
                return new DoubleArrayValue5(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4]);
            }
            case 6: {
                return new DoubleArrayValue6(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5]);
            }
            case 7: {
                return new DoubleArrayValue7(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6]);
            }
            case 8: {
                return new DoubleArrayValue8(this.values[o + 0], this.values[o + 1], this.values[o + 2], this.values[o + 3], this.values[o + 4], this.values[o + 5], this.values[o + 6], this.values[o + 7]);
            }
        }
        double[] v = new double[l];
        System.arraycopy(this.values, o, v, 0, l);
        return new DoubleArrayValue(v);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
        if (dest instanceof DoubleArrayValue) {
            DoubleArrayValue that = (DoubleArrayValue)dest;
            System.arraycopy(this.values, (int)srcOfs, that.values, (int)destOfs, (int)len);
        } else if (destOfs < srcOfs) {
            for (long i = 0L; i < len; ++i) {
                dest.setDouble(destOfs + i, this.getDouble(srcOfs + i));
            }
        } else {
            for (long i = len - 1L; i >= 0L; --i) {
                dest.setDouble(destOfs + i, this.getDouble(srcOfs + i));
            }
        }
    }

    public int hashCode() {
        int res = 0;
        int len = Math.min(32, this.values.length);
        for (int i = 0; i < len; ++i) {
            res += (int)Double.doubleToRawLongBits(this.values[i]);
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleArrayValue) {
            DoubleArrayValue that = (DoubleArrayValue)obj;
            return Arrays.equals(this.values, that.values);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DoubleArrayValue(");
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.values[i]);
        }
        sb.append(")");
        return sb.toString();
    }
}

