/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.nio.ByteOrder;

public final class PlatformUtils {
    private static final boolean IS_WINDOW_PLATFORM = PlatformUtils.initWindowPlatform();
    private static final boolean IS_BIG_ENDIAN_PLATFORM = PlatformUtils.initBigEndianPlatform();

    private PlatformUtils() {
    }

    public static boolean isWindowPlatform() {
        return IS_WINDOW_PLATFORM;
    }

    public static boolean isBigEndianPlatform() {
        return IS_BIG_ENDIAN_PLATFORM;
    }

    private static boolean initWindowPlatform() {
        try {
            String os = System.getProperty("os.name");
            return os != null && os.toLowerCase().indexOf("windows") > -1;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean initBigEndianPlatform() {
        return ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder());
    }
}

