/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.values;

import java.lang.invoke.MethodHandle;
import java.util.concurrent.atomic.AtomicLong;
import org.ocamljava.runtime.values.Value;

public final class MethodHandleValue
extends Value {
    private static final AtomicLong NEXT_MAGIC_NUMBER = new AtomicLong();
    private final MethodHandle handle;
    private final int arity;
    private final Value env;
    private final long magicNumber;

    MethodHandleValue(MethodHandle mh, Value e) {
        assert (mh != null) : "null mh";
        assert (e != null) : "null e";
        this.handle = mh;
        this.arity = mh.type().parameterCount();
        this.env = e;
        this.magicNumber = NEXT_MAGIC_NUMBER.getAndIncrement();
    }

    public MethodHandle getHandle() {
        return this.handle;
    }

    public int getArity() {
        return this.arity;
    }

    public Value getEnv() {
        return this.env;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isCodeOffset() {
        return true;
    }

    @Override
    public boolean isMethodHandle() {
        return true;
    }

    @Override
    public boolean isBlock() {
        return false;
    }

    @Override
    public boolean isDoubleArray() {
        return false;
    }

    @Override
    public boolean isLongBlock() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public long asLong() {
        return this.magicNumber;
    }

    @Override
    public long asCodeOffset() {
        return this.magicNumber;
    }

    @Override
    public int getApplicationKind() {
        return 1;
    }

    @Override
    public long getRawValue() {
        return this.magicNumber << 1;
    }

    @Override
    public int switchTag() {
        return -this.getTag();
    }

    @Override
    public MethodHandleValue duplicate() {
        return new MethodHandleValue(this.handle, this.env);
    }

    @Override
    public void copyValuesIntoArray(Value[] dest) {
    }

    @Override
    public void copyValuesIntoArray(Value[] dest, int destOfs) {
    }

    @Override
    public void copyDoublesIntoArray(double[] dest, int destOfs) {
    }

    @Override
    public void copyRawLongsIntoArray(long[] dest, int destOfs) {
    }

    @Override
    public Value subArray(long ofs, long len) {
        assert (false) : "subArray called on a non-array value";
        return Value.createBlock(0, 0L);
    }

    @Override
    public void blitArray(long srcOfs, Value dest, long destOfs, long len) {
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodHandleValue) {
            MethodHandleValue that = (MethodHandleValue)obj;
            return this == that;
        }
        return false;
    }

    public int hashCode() {
        return this.handle.hashCode() + this.env.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MethodHandleValue(handle=");
        sb.append(this.handle.toString());
        sb.append(", env=");
        sb.append(this.env.toString());
        sb.append(")");
        return sb.toString();
    }
}

