/*
 * Decompiled with CFR 0.152.
 */
package org.ocamljava.runtime.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class EncodingUtils {
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final char[] BYTE_TO_CHAR = EncodingUtils.byteToCharMap();
    private static final byte[] CHAR_TO_BYTE = EncodingUtils.charToByteMap();

    private EncodingUtils() {
    }

    private static char[] byteToCharMap() {
        byte[] ba = new byte[256];
        for (int i = -128; i <= 127; ++i) {
            ba[i - -128] = (byte)i;
        }
        char[] res = CHARSET.decode(ByteBuffer.wrap(ba)).array();
        assert (ba.length == res.length) : "invalid BYTE_TO_CHAR";
        return res;
    }

    private static byte[] charToByteMap() {
        char[] ca = new char[65536];
        for (int i = 0; i <= 65535; ++i) {
            ca[i - 0] = (char)i;
        }
        byte[] res = CHARSET.encode(CharBuffer.wrap(ca)).array();
        assert (ca.length == res.length) : "invalid CHAR_TO_BYTE";
        return res;
    }

    public static byte convertCharToByte(char ch) {
        return CHAR_TO_BYTE[ch - '\u0000'];
    }

    public static char convertByteToChar(byte by) {
        return BYTE_TO_CHAR[by - -128];
    }

    public static byte[] convertStringToBytes(String s) {
        assert (s != null) : "null s";
        byte[] res = new byte[s.length()];
        EncodingUtils.convertStringToBytes(s, res, 0);
        return res;
    }

    public static void convertStringToBytes(String s, byte[] dest, int ofs) {
        assert (s != null) : "null s";
        assert (dest != null) : "null dest";
        assert (ofs >= 0) : "ofs should be >= 0";
        assert (dest.length >= ofs + s.length()) : "invalid ofs";
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            dest[ofs + i] = CHAR_TO_BYTE[s.charAt(i) - '\u0000'];
        }
    }

    public static void convertCharsToBytes(char[] ch, byte[] dest, int ofs, int len) {
        assert (ch != null) : "null ch";
        assert (dest != null) : "null dest";
        assert (ofs >= 0) : "ofs should be >= 0";
        assert (len >= 0) : "len should be >= 0";
        assert (dest.length >= ofs + len) : "invalid ofs";
        assert (len <= ch.length) : "invalid len";
        for (int i = 0; i < len; ++i) {
            dest[ofs + i] = CHAR_TO_BYTE[ch[i] - '\u0000'];
        }
    }

    public static String convertBytesToString(byte[] b) {
        assert (b != null) : "null b";
        return EncodingUtils.convertBytesToString(b, 0, b.length);
    }

    public static String convertBytesToString(byte[] b, int ofs, int len) {
        assert (b != null) : "null b";
        assert (ofs >= 0) : "ofs should be >= 0";
        assert (len >= 0) : "len should be >= 0";
        assert (ofs + len <= b.length) : "invalid ofs";
        char[] res = new char[len];
        for (int i = 0; i < len; ++i) {
            res[i] = BYTE_TO_CHAR[b[ofs + i] - -128];
        }
        return new String(res);
    }
}

